/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.libVulpes.util.ZUtils;

public class SatelliteLaserNoDrill
extends SatelliteBase {
    protected boolean jammed;
    protected IInventory boundChest;
    World world;
    private static List<ItemStack> ores;
    Random random;

    public SatelliteLaserNoDrill(IInventory boundChest) {
        this.boundChest = boundChest;
        this.random = new Random(System.currentTimeMillis());
        if (ores == null && !ARConfiguration.getCurrentConfig().standardLaserDrillOres.isEmpty()) {
            ores = new LinkedList<ItemStack>();
            for (int i = 0; i < ARConfiguration.getCurrentConfig().standardLaserDrillOres.size(); ++i) {
                String name;
                String oreDictName = ARConfiguration.getCurrentConfig().standardLaserDrillOres.get(i);
                String[] args = oreDictName.split(":");
                NonNullList ores2 = OreDictionary.getOres((String)args[0]);
                if (ores2 != null && !ores2.isEmpty()) {
                    int amt = 5;
                    if (args.length > 1) {
                        try {
                            amt = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ores.add(new ItemStack(((ItemStack)ores2.get(0)).func_77973_b(), amt, ((ItemStack)ores2.get(0)).func_77952_i()));
                    continue;
                }
                String[] splitStr = oreDictName.split(":");
                try {
                    name = splitStr[0] + ":" + splitStr[1];
                }
                catch (IndexOutOfBoundsException e) {
                    AdvancedRocketry.logger.warn("Unexpected ore name: \"" + oreDictName + "\" during laser drill harvesting");
                    continue;
                }
                int meta = 0;
                int size = 1;
                if (splitStr.length > 2) {
                    try {
                        meta = Integer.parseInt(splitStr[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (splitStr.length > 3) {
                    try {
                        size = Integer.parseInt(splitStr[3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ItemStack stack = ItemStack.field_190927_a;
                Block block = Block.func_149684_b((String)name);
                if (block == null) {
                    Item item = Item.func_111206_d((String)name);
                    if (item != null) {
                        stack = new ItemStack(item, size, meta);
                    }
                } else {
                    stack = new ItemStack(block, size, meta);
                }
                if (stack.func_190926_b()) continue;
                ores.add(stack);
            }
        }
    }

    public boolean isAlive() {
        return this.world != null;
    }

    public boolean isFinished() {
        return false;
    }

    public boolean getJammed() {
        return this.jammed;
    }

    public void setJammed(boolean newJam) {
        this.jammed = newJam;
    }

    public void deactivateLaser() {
        this.world = null;
    }

    public boolean activateLaser(World world, int x, int z) {
        this.world = world;
        return true;
    }

    public void performOperation() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.random.nextInt(10) == 0) {
            ItemStack item = ores.get(this.random.nextInt(ores.size()));
            ItemStack newStack = item.func_77946_l();
            items.add(newStack);
        } else {
            items.add(new ItemStack(Blocks.field_150347_e, 5));
        }
        if (this.boundChest != null) {
            ItemStack[] stacks = new ItemStack[items.size()];
            stacks = items.toArray(stacks);
            ZUtils.mergeInventory((ItemStack[])stacks, (IInventory)this.boundChest);
            if (!ZUtils.isInvEmpty((ItemStack[])stacks)) {
                this.deactivateLaser();
                this.jammed = true;
                return;
            }
        }
    }

    @Override
    public String getInfo(World world) {
        return null;
    }

    @Override
    public String getName() {
        return "Laser";
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        this.performOperation();
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("jammed", this.jammed);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.jammed = nbt.func_74767_n("jammed");
    }

    @Override
    public boolean canTick() {
        return false;
    }

    @Override
    public void tickEntity() {
    }
}

