/*
 * Decompiled with CFR 0.152.
 */
package com.minerarcana.floralchemy.botania;

import com.minerarcana.floralchemy.api.FloralchemyAPI;
import com.minerarcana.floralchemy.botania.LexiconPages;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;

public class SubTilePetroPetunia
extends SubTileGenerating {
    public static final String NAME = "petro_petunia";
    private static final int START_BURN_EVENT = 0;
    private static final String TAG_BURN_TIME = "burn_time";
    private static final String TAG_POWER = "tick_power";
    private static final String TAG_COOL_DOWN = "cool_down";
    private int burnTime;
    private int powerPerTick;
    private int coolDown;

    public void onUpdate() {
        super.onUpdate();
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (this.getWorld().field_72995_K) {
            if (this.burnTime > 0 && this.supertile.func_145831_w().field_73012_v.nextInt(10) == 0) {
                Vec3d offset = this.getWorld().func_180495_p(this.getPos()).func_191059_e((IBlockAccess)this.getWorld(), this.getPos()).func_72441_c(0.4, 0.7, 0.4);
                this.supertile.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.supertile.func_174877_v().func_177958_n() + offset.field_72450_a + Math.random() * 0.2, (double)this.supertile.func_174877_v().func_177956_o() + offset.field_72448_b, (double)this.supertile.func_174877_v().func_177952_p() + offset.field_72449_c + Math.random() * 0.2, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (this.linkedCollector != null && this.burnTime <= 0 && this.redstoneSignal == 0 && this.coolDown <= 0 && this.mana < this.getMaxMana()) {
            boolean foundFluid = false;
            for (int tries = 0; tries < 9 && !foundFluid; ++tries) {
                Optional<Tuple<Integer, Integer>> fuelInfo;
                FluidStack grabbedFluid;
                BlockPos checkingPos = this.getPos().func_177982_a(-1 + tries / 3, -1, -1 + tries % 3);
                IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)this.getWorld(), (BlockPos)checkingPos, (EnumFacing)EnumFacing.UP);
                if (fluidHandler == null || (grabbedFluid = fluidHandler.drain(1000, false)) == null || grabbedFluid.getFluid() == null || grabbedFluid.amount != 1000 || !(fuelInfo = FloralchemyAPI.getFluidFuelRegistry().getFuelInfo(grabbedFluid.getFluid().getName())).isPresent()) continue;
                foundFluid = true;
                this.burnTime = (Integer)fuelInfo.get().func_76341_a();
                this.powerPerTick = (Integer)fuelInfo.get().func_76340_b();
                fluidHandler.drain(1000, true);
                this.sync();
            }
            if (!foundFluid) {
                this.coolDown = 100;
            }
        }
    }

    public boolean receiveClientEvent(int event, int param) {
        if (event == 0) {
            return true;
        }
        return super.receiveClientEvent(event, param);
    }

    public int getMaxMana() {
        return 9000;
    }

    public int getValueForPassiveGeneration() {
        return this.powerPerTick * this.getDelayBetweenPassiveGeneration();
    }

    public boolean canGeneratePassively() {
        return this.burnTime > 0;
    }

    public int getDelayBetweenPassiveGeneration() {
        return 2;
    }

    public boolean acceptsRedstone() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 1);
    }

    public int getColor() {
        return Color.BLACK.getRGB();
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BURN_TIME, this.burnTime);
        cmp.func_74768_a(TAG_COOL_DOWN, this.coolDown);
        cmp.func_74768_a(TAG_POWER, this.powerPerTick);
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.func_74762_e(TAG_BURN_TIME);
        this.coolDown = cmp.func_74762_e(TAG_COOL_DOWN);
        this.powerPerTick = cmp.func_74762_e(TAG_POWER);
    }

    public LexiconEntry getEntry() {
        return LexiconPages.petroPetunia;
    }
}

