/*
 * Decompiled with CFR 0.152.
 */
package com.minerarcana.floralchemy.block;

import com.minerarcana.floralchemy.item.ItemBlockTinted;
import com.teamacronymcoders.base.blocks.IHasBlockColor;
import com.teamacronymcoders.base.blocks.IHasItemBlock;
import com.teamacronymcoders.base.client.ClientHelper;
import com.teamacronymcoders.base.util.ColourHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCrystalthorn
extends BlockBush
implements IHasBlockColor,
IHasItemBlock {
    public static final int maxAge = 7;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final PropertyBool BERRIES = PropertyBool.func_177716_a((String)"berries");
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.4, 0.7), new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.5, 0.8), new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.6, 0.8), new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.6, 0.8), new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.6, 0.9), new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.6, 0.9), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private Tuple<ResourceLocation, Integer> crystal;
    private ItemBlock itemBlock;
    private ItemStack cachedCrystalStack = ItemStack.field_190927_a;
    private Optional<Integer> cachedColor = Optional.empty();

    public BlockCrystalthorn(Tuple<ResourceLocation, Integer> entry) {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("crystalthorn");
        this.func_149675_a(true);
        this.crystal = entry;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.getCrystalStack().func_82833_r());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        if ((Integer)state.func_177229_b((IProperty)AGE) == 7 && ((Boolean)state.func_177229_b((IProperty)BERRIES)).booleanValue() && !(stack = this.getCrystalStack()).func_190926_b() && playerIn.func_191521_c(stack)) {
            playerIn.func_70097_a(DamageSource.field_76367_g, 3.0f);
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(false)));
        }
        return false;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (random.nextBoolean()) {
            if ((Integer)state.func_177229_b((IProperty)AGE) < 7) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)));
                return;
            }
            if (!((Boolean)state.func_177229_b((IProperty)BERRIES)).booleanValue() && random.nextInt(10) == 0) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 8) {
            return this.func_176223_P().func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7));
        }
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BERRIES) != false ? (Integer)state.func_177229_b((IProperty)AGE) : (Integer)state.func_177229_b((IProperty)AGE) + 1;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, BERRIES});
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_70097_a(DamageSource.field_76367_g, 3.0f);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        IResource resource;
        if (this.cachedColor.isPresent()) {
            return this.cachedColor.get();
        }
        ItemStack cStack = this.getCrystalStack();
        int tintColor = Minecraft.func_71410_x().getItemColors().func_186728_a(cStack, 0);
        if (tintColor == -1 && (resource = ClientHelper.getResource((ResourceLocation)new ResourceLocation(((ResourceLocation)this.crystal.func_76341_a()).func_110624_b(), "textures/items/" + ((ResourceLocation)this.crystal.func_76341_a()).func_110623_a() + ".png"))) != null) {
            InputStream stream = resource.func_110527_b();
            tintColor = ColourHelper.getColour((InputStream)stream);
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.cachedColor = Optional.of(tintColor);
        return tintColor;
    }

    public Block getBlock() {
        return this;
    }

    public ItemBlock getItemBlock() {
        return this.itemBlock == null ? new ItemBlockTinted<BlockCrystalthorn>(this) : this.itemBlock;
    }

    public ItemStack getCrystalStack() {
        if (this.cachedCrystalStack.func_190926_b()) {
            this.cachedCrystalStack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)this.crystal.func_76341_a()), 1, ((Integer)this.crystal.func_76340_b()).intValue());
        }
        return this.cachedCrystalStack;
    }
}

