/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.proxy;

import java.net.Proxy;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.CustomStateMapper;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.command.CommandTBGui;
import ovh.corail.tombstone.compatibility.CompatibilityGraveStone;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.event.ClientEventHandler;
import ovh.corail.tombstone.item.ICustomModel;
import ovh.corail.tombstone.particle.ParticleCasting;
import ovh.corail.tombstone.particle.ParticleGraveSmoke;
import ovh.corail.tombstone.particle.ParticleGraveSoul;
import ovh.corail.tombstone.particle.ParticleShadowStep;
import ovh.corail.tombstone.particle.ParticleSmokeColumn;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.RegistryHandler;
import ovh.corail.tombstone.render.RenderWritableGrave;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
implements IProxy {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWritableGrave.class, (TileEntitySpecialRenderer)new RenderWritableGrave());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void postInit() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTBGui());
        final String incompatibleMessage = CompatibilityGraveStone.instance.isEuhDawson() ? "you loaded an incompatible grave mod : GraveStone (from EuhDawnson)" : (SupportMods.TOMB_MANY_GRAVES.isLoaded() ? "you loaded an incompatible grave mod : TombManyGraves" : (SupportMods.GOTTSCHCORE.isLoaded() || SupportMods.TREASURE2.isLoaded() ? "you loaded a mod not respecting the Tombstone's License making it incompatible : Gottsch's Mods" : (SupportMods.OPENGRAVE.isLoaded() ? "you loaded an incompatible grave mod : OpenGrave" : (SupportMods.CORPSE.isLoaded() ? "you loaded an incompatible grave mod : Corpse" : null))));
        if (incompatibleMessage != null) {
            throw new CustomModLoadingErrorDisplayException("Corail Tombstone Exception", new RuntimeException(incompatibleMessage)){

                public void initGui(GuiErrorScreen parent, FontRenderer fontRenderer) {
                }

                public void drawScreen(GuiErrorScreen parent, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
                    parent.func_73732_a(parent.field_146297_k.field_71466_p, "Corail Tombstone Exception : ", parent.field_146294_l / 2, 90, 0xFFFFFF);
                    parent.func_73732_a(parent.field_146297_k.field_71466_p, incompatibleMessage, parent.field_146294_l / 2, 110, 0xFFFFFF);
                }
            };
        }
    }

    @Override
    public void produceGraveSmoke(World world, BlockPos pos) {
        if (ConfigTombstone.client.fogDensity != ConfigTombstone.CatClient.FogDensity.NONE) {
            for (int i = 0; i <= ConfigTombstone.client.fogDensity.ordinal(); ++i) {
                ParticleGraveSmoke particle = new ParticleGraveSmoke(world, (double)pos.func_177958_n() + world.field_73012_v.nextGaussian(), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian(), (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.03, 0.0, (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.03);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    @Override
    public void produceShadowStep(EntityLivingBase entity, float color) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.equals((Object)entity) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            return;
        }
        if (!entity.func_184218_aH() && !entity.func_70608_bn()) {
            for (double i = 0.0; i < 1.0; i += 0.15) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleShadowStep(entity, i, color));
            }
        }
    }

    @Override
    public void produceGraveSoul(World world, BlockPos pos) {
        ParticleGraveSoul particle = new ParticleGraveSoul(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.3);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    public void produceParticleCasting(EntityLivingBase caster, Predicate<EntityLivingBase> predic) {
        if (caster != null) {
            for (int i = 1; i <= 2; ++i) {
                ParticleCasting particle = new ParticleCasting(caster.field_70170_p, caster, predic, 0.0, (double)i * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 0.5, (double)(i + 1) * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 1.0, (double)i * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 1.5, (double)(i + 1) * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 2.0, (double)i * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    @Override
    public void produceSmokeColumn(World world, double x, double y, double z) {
        for (int i = 0; i < 6; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn(world, x - 0.1, y, z - 0.1, i));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn(world, x - 0.1, y, z + 0.1, i));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn(world, x + 0.1, y, z - 0.1, i));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn(world, x + 0.1, y, z + 0.1, i));
        }
    }

    @Override
    public void registerModels() {
        for (BlockGrave blockGrave : RegistryHandler.graves) {
            ModelLoader.setCustomStateMapper((Block)blockGrave, (IStateMapper)new CustomStateMapper());
        }
        for (BlockGraveBase blockGraveBase : RegistryHandler.decorative_graves) {
            ModelLoader.setCustomStateMapper((Block)blockGraveBase, (IStateMapper)new CustomStateMapper());
            ((ItemBlockGrave)Item.func_150898_a((Block)blockGraveBase)).initModel();
        }
        assert (ModBlocks.dark_marble.getRegistryName() != null);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.dark_marble), (int)0, (ModelResourceLocation)new ModelResourceLocation(ModBlocks.dark_marble.getRegistryName(), "inventory"));
        for (BlockGraveBase blockGraveBase : RegistryHandler.items) {
            if (blockGraveBase instanceof ICustomModel) {
                ((ICustomModel)((Object)blockGraveBase)).registerModels();
                continue;
            }
            assert (blockGraveBase.getRegistryName() != null);
            ModelLoader.setCustomModelResourceLocation((Item)blockGraveBase, (int)0, (ModelResourceLocation)new ModelResourceLocation(blockGraveBase.getRegistryName(), "inventory"));
        }
    }

    @Override
    public Proxy getNetProxy() {
        return Minecraft.func_71410_x().func_110437_J();
    }
}

