/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;

public class PerkDisenchantment
extends Perk {
    PerkDisenchantment() {
        super("disenchantment", new ResourceLocation("tombstone", "textures/items/book_of_disenchantment.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled() {
        return !ConfigTombstone.allowedMagicItems.isAllowedBookOfDisenchantment();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return level + 1 + " " + LangKey.makeClientTranslation("tombstone.perk.disenchantment.desc", new Object[0]);
        }
        if (level == actualLevel + 1) {
            return level + 1 + "";
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        return Helper.isDateAroundHalloween() ? 5 : 0;
    }
}

