/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.NonNullList;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ICustomModel;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollBuff
extends ItemScroll
implements ICustomModel {
    public ItemScrollBuff() {
        super("scroll_buff");
        this.field_77787_bX = true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (SpellBuff buff : SpellBuff.values()) {
                items.add((Object)new ItemStack((Item)this, 1, buff.ordinal()));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            list.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_DESC, this.func_77667_c(stack) + ".desc", new Object[0]));
            this.addItemUse(list, this.isEnchanted(stack) ? LangKey.ITEM_SCROLL_BUFF_USE2 : LangKey.ITEM_SCROLL_BUFF_USE1, new Object[0]);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            list.add(StyleType.MESSAGE_SPELL.func_150218_j() + "(" + StringUtils.func_76337_a((int)MathHelper.func_76141_d((float)((float)ConfigTombstone.general.getScrollDuration() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.mastery_of_scrolls) / 10.0f)))) + ")");
            if (SpellBuff.getSpellBuf(stack) == SpellBuff.REACH) {
                this.addInfoInBeta(list);
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return ConfigTombstone.allowedMagicItems.allowScrollOfPreservation;
            }
            case 1: {
                return ConfigTombstone.allowedMagicItems.allowScrollOfUnstableIntangibleness;
            }
            case 2: {
                return ConfigTombstone.allowedMagicItems.allowScrollOfFeatherFall;
            }
            case 3: {
                return ConfigTombstone.allowedMagicItems.allowScrollOfPurification;
            }
            case 4: {
                return ConfigTombstone.allowedMagicItems.allowScrollOfTrueSight;
            }
            case 5: {
                return ConfigTombstone.allowedMagicItems.allowScrollOfReach;
            }
        }
        return false;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return true;
        }
        return false;
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        SpellBuff buff = SpellBuff.values()[stack.func_77960_j()];
        EntityHelper.addPotion((EntityLivingBase)player, buff.potion, MathHelper.func_76128_c((double)((double)ConfigTombstone.general.getScrollDuration() * (1.0 + (double)EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.mastery_of_scrolls) / 10.0))), buff.amplifier, new boolean[0]);
        LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMagicMessage((ICommandSender)player, LangKey.makeTranslationWithStyle(StyleType.MESSAGE_SPECIAL, buff.potion.func_76393_a(), new Object[0]));
        ModTriggers.SPELL_BUFF.get((Object)buff).trigger(player);
        return true;
    }

    @Override
    public void registerModels() {
        for (SpellBuff buff : SpellBuff.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)buff.ordinal(), (ModelResourceLocation)new ModelResourceLocation("tombstone:" + buff.getScrollName(), "inventory"));
        }
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return "tombstone.item." + SpellBuff.values()[stack.func_77960_j()].getScrollName();
    }

    public static enum SpellBuff {
        PRESERVATION(ModEffects.preservation, 0),
        UNSTABLE_INTANGIBLENESS(ModEffects.unstable_intangibleness, 0),
        FEATHER_FALL(ModEffects.feather_fall, 3),
        PURIFICATION(ModEffects.purification, 1),
        TRUE_SIGHT(ModEffects.true_sight, 0),
        REACH(ModEffects.reach, 5);

        private final Potion potion;
        private final int amplifier;

        private SpellBuff(Potion potion, int amplifier) {
            this.potion = potion;
            this.amplifier = amplifier;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        private String getScrollName() {
            return "scroll_of_" + this.getName();
        }

        public static SpellBuff getSpellBuf(ItemStack stack) {
            return SpellBuff.values()[MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(SpellBuff.values().length - 1))];
        }

        public static SpellBuff getRandomBuff() {
            return SpellBuff.values()[Helper.getRandom(0, SpellBuff.values().length - 1)];
        }
    }
}

