/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.enchantment.WeaponEnchantment;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEnchantments;

public class EnchantmentPlagueBringer
extends WeaponEnchantment {
    public EnchantmentPlagueBringer() {
        super("plague_bringer", Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
    }

    @Override
    protected boolean isEnabled() {
        return ConfigTombstone.enchantments.isEnableEnchantmentPlagueBringer();
    }

    @Override
    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != ModEnchantments.magic_siphon;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    @Override
    public int func_77325_b() {
        return 3;
    }

    @Override
    public void onEntityDamaged(EntityLivingBase attacker, EntityLivingBase target, EntityEquipmentSlot slot, int level) {
        PotionEffect effect;
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return;
        }
        boolean canAffectTarget = target.func_70089_S();
        if (canAffectTarget && Helper.random.nextFloat() < (float)level * 0.1f && (effect = Helper.getRandomEffect(ConfigTombstone.enchantments.durationPlagueBringer, true)) != null) {
            boolean canAffectAttacker;
            target.func_70690_d(effect);
            boolean bl = canAffectAttacker = ConfigTombstone.enchantments.nerfPlagueBringer && (!EntityHelper.isValidPlayerMP((Entity)attacker) || !Helper.isContributor((EntityPlayer)((EntityPlayerMP)attacker)) && !EntityHelper.isBadAlignment((EntityPlayerMP)attacker));
            if (canAffectAttacker) {
                attacker.func_70690_d(effect);
            }
        }
    }
}

