/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SupportStructures;

public class CommandTBTeleportDiscovery
extends TombstoneCommand {
    private static final String name = "tbteleportdiscovery";

    public String func_71517_b() {
        return name;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int targetDim;
        SupportStructures struct;
        if (args.length < 1 || args.length > 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        Entity target = CommandTBTeleportDiscovery.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        CommandTBTeleportDiscovery.checkAlive(target);
        CommandTBTeleportDiscovery.checkNotSpectator(target);
        SupportStructures supportStructures = struct = args.length == 1 ? SupportStructures.Village : SupportStructures.getStructure(args[1]);
        if (struct == null) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_INVALID_STRUCTURE.getKey(), new Object[0]);
        }
        int n = targetDim = args.length == 3 ? CommandTBTeleportDiscovery.func_175755_a((String)args[2]) : target.field_70170_p.field_73011_w.getDimension();
        if (!Helper.isValidDimension(targetDim)) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_DIMENSION.getKey(), new Object[0]);
        }
        WorldServer world = server.func_71218_a(targetDim);
        Location structureLoc = Helper.findNearestStructure(world, target.func_180425_c(), struct, true);
        if (structureLoc.isOrigin()) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_STRUCTURE.getKey(), new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, structureLoc.getPos(), true).findPlaceInStructure(struct);
        if (spawnLoc.isOrigin()) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_SPAWN.getKey(), new Object[0]);
        }
        Entity newEntity = Helper.teleportEntity(target, spawnLoc);
        CommandTBTeleportDiscovery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_LOG_TELEPORT_SUCCESS.getKey(), (Object[])new Object[]{target.func_70005_c_(), spawnLoc.x, spawnLoc.y, spawnLoc.z, spawnLoc.dim});
        LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newEntity, new Object[0]);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 1 || args.length > 3) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandTBTeleportDiscovery.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandTBTeleportDiscovery.func_175762_a((String[])args, Arrays.asList(SupportStructures.values()));
        }
        return Helper.getDimensionIdsAsStringList();
    }
}

