/*
 * Decompiled with CFR 0.152.
 */
package lykrast.jetif.compat;

import java.awt.Color;
import java.util.List;
import lykrast.jetif.JETIFCompat;
import lykrast.jetif.JETIFWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CompatAtum2
extends JETIFCompat {
    private static final String INFO = "jetif.atum.chance";

    public CompatAtum2() {
        super("atum");
    }

    @Override
    public void addRecipes(List<JETIFWrapper> list) {
        int i;
        FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);
        double coinFailChance = 0.1;
        list.add(new WrapperNumbered(water, CompatAtum2.getModdedItem("atum:coin_gold"), (int)(100.0 * (1.0 - coinFailChance)), CompatAtum2.getModdedItem("atum:coin_dirty")));
        double lootFailChance = 0.1;
        String[] types = new String[]{"idol", "necklace", "ring", "broach", "scepter"};
        String[] qualities = new String[]{"silver", "gold", "sapphire", "ruby", "emerald", "diamond"};
        int[] weights = new int[]{48, 25, 20, 15, 10, 5};
        double totalWeight = 0.0;
        for (i = 0; i < weights.length; ++i) {
            totalWeight += (double)weights[i];
        }
        for (i = 0; i < weights.length; ++i) {
            weights[i] = (int)(100.0 * ((double)weights[i] / totalWeight) * (1.0 - lootFailChance));
        }
        for (String s : types) {
            for (int i2 = 0; i2 < qualities.length; ++i2) {
                list.add(new WrapperNumbered(water, CompatAtum2.getModdedItem("atum:loot_" + qualities[i2] + "_" + s), weights[i2], CompatAtum2.getModdedItem("atum:loot_dirty_" + s)));
            }
        }
    }

    private static class WrapperNumbered
    extends JETIFWrapper {
        private int chance;

        public WrapperNumbered(FluidStack fluid, ItemStack out, int chance, ItemStack ... input) {
            super(fluid, CompatAtum2.INFO, out, input);
            this.chance = chance;
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.info == null) {
                return;
            }
            String text = I18n.func_135052_a((String)this.info, (Object[])new Object[]{this.chance});
            int width = minecraft.field_71466_p.func_78256_a(text);
            int x = (recipeWidth - width) / 2;
            int y = 35;
            minecraft.field_71466_p.func_78276_b(text, x, y, Color.GRAY.getRGB());
        }
    }
}

