/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container;

import com.valkyrieofnight.vlib.core.util.MathUtil;
import com.valkyrieofnight.vliblegacy.lib.client.gui.base.IGuiDraw;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElement;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.VLContFixedSize;
import com.valkyrieofnight.vliblegacy.lib.util.client.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;

public abstract class VLContScissorPane
extends VLContFixedSize {
    protected int xScroll = 0;
    protected int yScroll = 0;
    protected int xScrollMin = 0;
    protected int yScrollMin = 0;
    protected int xScrollMax = 0;
    protected int yScrollMax = 0;
    protected int zoom = 10;

    public VLContScissorPane(String elementID, int xSize, int ySize) {
        super(elementID, xSize, ySize);
    }

    public VLContScissorPane(String elementID) {
        this(elementID, 0, 0);
    }

    public void resetScroll() {
        this.xScroll = 0;
        this.yScroll = 0;
    }

    public void setYScroll(int amt) {
        this.yScroll = MathUtil.clamp(amt, this.yScrollMin, this.yScrollMax);
    }

    public void setXScroll(int amt) {
        this.xScroll = MathUtil.clamp(amt, this.xScrollMin, this.xScrollMax);
    }

    public void addYScroll(int amt) {
        this.yScroll = MathUtil.clamp(this.yScroll + amt, this.yScrollMin, this.yScrollMax);
    }

    public void addXScroll(int amt) {
        this.xScroll = MathUtil.clamp(this.xScroll + amt, this.xScrollMin, this.xScrollMax);
    }

    public void setScrollMin(int xScrollMin, int yScrollMin) {
        this.xScrollMin = xScrollMin;
        this.yScrollMin = yScrollMin;
    }

    public void setScrollMax(int xScrollMax, int yScrollMax) {
        this.xScrollMax = xScrollMax;
        this.yScrollMax = yScrollMax;
    }

    public float getZoomDiv() {
        return 10.0f;
    }

    @Override
    public void drawBackgroundLayer(int mx, int my, float partialTicks) {
        float zoomSize = (float)this.zoom / this.getZoomDiv();
        GlStateManager.func_179094_E();
        RenderUtil.guiScissorStart(Minecraft.func_71410_x(), this.gui.getGuiLeft() + this.xPosOffset + 1, this.gui.getGuiTop() + this.yPosOffset + 1, this.xSize - 2, this.ySize - 2);
        GlStateManager.func_179152_a((float)zoomSize, (float)zoomSize, (float)1.0f);
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiDraw) || !((IGuiDraw)((Object)ele)).isBackgroundVisible()) continue;
            ((IGuiDraw)((Object)ele)).drawBackgroundLayer(mx, my, partialTicks);
        }
        RenderUtil.guiScissorEnd(Minecraft.func_71410_x(), this.gui.getGuiLeft() + this.xPosOffset + 1, this.gui.getGuiTop() + this.yPosOffset + 1, this.xSize - 2, this.ySize - 2);
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawForegroundLayer(int mx, int my, float partialTicks) {
        float zoomSize = (float)this.zoom / this.getZoomDiv();
        GlStateManager.func_179094_E();
        RenderUtil.guiScissorStart(Minecraft.func_71410_x(), this.gui.getGuiLeft() + this.xPosOffset + 1, this.gui.getGuiTop() + this.yPosOffset + 1, this.xSize - 2, this.ySize - 2);
        GlStateManager.func_179152_a((float)zoomSize, (float)zoomSize, (float)1.0f);
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiDraw) || !((IGuiDraw)((Object)ele)).isForegroundVisible()) continue;
            ((IGuiDraw)((Object)ele)).drawForegroundLayer(mx, my, partialTicks);
        }
        RenderUtil.guiScissorEnd(Minecraft.func_71410_x(), this.gui.getGuiLeft() + this.xPosOffset + 1, this.gui.getGuiTop() + this.yPosOffset + 1, this.xSize - 2, this.ySize - 2);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onMouseClicked(int mx, int my, int mouseButton) {
        return super.onMouseClicked(mx, my, mouseButton);
    }

    @Override
    public boolean onMouseScrolled(int mx, int my, int scroll) {
        this.addYScroll(-scroll * 12);
        return super.onMouseScrolled(mx, my, scroll);
    }

    @Override
    public int getGuiLeft() {
        return (int)((float)(this.gui.getGuiLeft() + this.xPosOffset) + (float)this.xScroll * ((float)this.zoom / this.getZoomDiv()));
    }

    @Override
    public int getGuiTop() {
        return (int)((float)(this.gui.getGuiTop() + this.yPosOffset) + (float)this.yScroll * ((float)this.zoom / this.getZoomDiv()));
    }

    @Override
    public void readOtherFromNBT(NBTTagCompound nbt) {
        this.xScroll = nbt.func_74762_e("x_scroll");
        this.yScroll = nbt.func_74762_e("y_scroll");
    }

    @Override
    public NBTTagCompound writeOtherToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x_scroll", this.xScroll);
        nbt.func_74768_a("y_scroll", this.yScroll);
        return nbt;
    }
}

