/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.CycleButton;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.PacketRedstoneMode;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RedstoneModeButton<T extends TileEntity>
extends CycleButton<RedstoneControlMode.IconHolder> {
    @Nonnull
    private IRedstoneModeControlable model;
    private T te;

    public RedstoneModeButton(@Nonnull IGuiScreen gui, int id, int x, int y, @Nonnull IRedstoneModeControlable model) {
        super(gui, id, x, y, RedstoneControlMode.IconHolder.class);
        this.model = model;
        this.setModeRaw(RedstoneControlMode.IconHolder.getFromMode(model.getRedstoneControlMode()));
    }

    public RedstoneModeButton(@Nonnull IGuiScreen gui, int id, int x, int y, @Nonnull T te) {
        this(gui, id, x, y, (IRedstoneModeControlable)te);
        this.te = te;
    }

    public void setModeRaw(@Nonnull RedstoneControlMode.IconHolder newMode) {
        super.setMode((Enum)newMode);
        this.setToolTip(new String[]{Lang.GUI_REDSTONE_MODE.get(), ((RedstoneControlMode.IconHolder)this.getMode()).getTooltip()});
    }

    public void setMode(@Nonnull RedstoneControlMode.IconHolder newMode) {
        this.setModeRaw(newMode);
        this.model.setRedstoneControlMode(((RedstoneControlMode.IconHolder)this.getMode()).getMode());
        if (this.te != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneMode(this.te));
        }
    }
}

