/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import gtclassic.api.interfaces.IGTDebuggableTile;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.INullableRecipeInput;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityAdvancedMachine;
import ic2.core.block.base.util.output.SimpleStackOutput;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.helpers.CompareableStack;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import ic2.core.util.obj.ITankListener;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import trinsdar.ic2c_extras.container.ContainerThermalWasher;
import trinsdar.ic2c_extras.recipes.Ic2cExtrasRecipes;
import trinsdar.ic2c_extras.util.GuiMachine;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasResourceLocations;

@Optional.Interface(iface="gtclassic.api.interfaces.IGTDebuggableTile", modid="gtclassic", striprefs=true)
public class TileEntityThermalWasher
extends TileEntityAdvancedMachine
implements ITankListener,
IFluidHandler,
IClickable,
IGTDebuggableTile {
    @NetworkField(index=13)
    public IC2Tank waterTank = new IC2Tank(FluidRegistry.getFluidStack((String)FluidRegistry.WATER.getName(), (int)0), 20000);
    public int water = 0;
    public int maxWater = 20000;
    public static final int slotFuel = 0;
    public static final int slotInput = 1;
    public static final int slotOutput = 2;
    public static final int slotOutput2 = 3;
    public static final int slotOutput3 = 4;
    public static final int slotInputTank = 5;
    public static final int slotOutputTank = 6;
    public IFilter filter = new MachineFilter((IMachine)this);

    public TileEntityThermalWasher() {
        super(7, 16, 4000);
        this.waterTank.addListener((ITankListener)this);
        this.waterTank.setCanFill(true);
        this.addGuiFields(new String[]{"waterTank"});
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, new int[]{0});
        handler.registerDefaultSlotAccess(AccessRule.Import, new int[]{1});
        handler.registerDefaultSlotAccess(AccessRule.Export, new int[]{2, 3, 4, 6});
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), new int[]{2, 3, 4});
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), new int[]{1});
        handler.registerInputFilter((IFilter)new ArrayFilter(new IFilter[]{CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)}), new int[]{0});
        handler.registerInputFilter(this.filter, new int[]{1});
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, new int[]{0});
        handler.registerSlotType(SlotType.Fuel, new int[]{0});
        handler.registerSlotType(SlotType.Input, new int[]{1, 5});
        handler.registerSlotType(SlotType.Output, new int[]{2, 3, 4, 6});
    }

    public boolean isValidInput(ItemStack par1) {
        return super.isValidInput(par1) && this.isRecipeInputValid(par1);
    }

    public boolean isRecipeInputValid(ItemStack stack) {
        IRecipeInput input = Ic2cExtrasRecipes.oreWashingPlantValidInputs.get(new CompareableStack(stack));
        if (input == null) {
            return false;
        }
        return input.matches(stack);
    }

    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        return Ic2cExtrasRecipes.oreWashingPlant.getRecipeInAndOutput(input, false);
    }

    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiMachine.OreWashingPlantGui.class;
    }

    public int[] getOutputSlots() {
        return new int[]{2, 3, 4};
    }

    public Slot[] getInventorySlots(InventoryPlayer inventoryPlayer) {
        return new Slot[0];
    }

    public ResourceLocation getTexture() {
        return Ic2cExtrasResourceLocations.thermalWasher;
    }

    public LocaleComp getSpeedName() {
        return Ic2GuiLang.machineHeat;
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.thermalWasher;
    }

    public IMachineRecipeList getRecipeList() {
        return Ic2cExtrasRecipes.oreWashingPlant;
    }

    public MachineType getType() {
        return null;
    }

    public double getWrenchDropRate() {
        return 1.0;
    }

    public ResourceLocation getProcessSoundFile() {
        return Ic2cExtrasResourceLocations.oreWashingPlantOp;
    }

    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerThermalWasher(player.field_71071_by, this);
    }

    public void func_73660_a() {
        if (!((ItemStack)this.inventory.get(5)).func_190926_b()) {
            this.handleTank();
        }
        super.func_73660_a();
    }

    public IMachineRecipeList.RecipeEntry getRecipe(int slot) {
        EnumActionResult result;
        if (this.notCheckRecipe.contains(slot)) {
            return (IMachineRecipeList.RecipeEntry)this.activeRecipes.get(slot);
        }
        this.notCheckRecipe.add(slot);
        if (((ItemStack)this.inventory.get(slot)).func_190926_b() && !this.canWorkWithoutItems()) {
            this.lastRecipes.remove(slot);
            this.activeRecipes.remove(slot);
            return null;
        }
        IMachineRecipeList.RecipeEntry lastRecipe = (IMachineRecipeList.RecipeEntry)this.lastRecipes.get(slot);
        if (lastRecipe != null) {
            IRecipeInput recipe = lastRecipe.getInput();
            if (recipe instanceof INullableRecipeInput) {
                if (!recipe.matches((ItemStack)this.inventory.get(slot))) {
                    this.lastRecipes.remove(slot);
                    this.activeRecipes.remove(slot);
                    lastRecipe = null;
                }
            } else if (!((ItemStack)this.inventory.get(slot)).func_190926_b() && recipe.matches((ItemStack)this.inventory.get(slot))) {
                if (recipe.getAmount() > ((ItemStack)this.inventory.get(slot)).func_190916_E()) {
                    this.activeRecipes.remove(slot);
                    return null;
                }
                EnumActionResult result2 = this.isRecipeStillValid(lastRecipe);
                if (result2 == EnumActionResult.FAIL) {
                    this.lastRecipes.remove(slot);
                    this.activeRecipes.remove(slot);
                    lastRecipe = null;
                } else if (result2 == EnumActionResult.PASS) {
                    this.activeRecipes.remove(slot);
                    return null;
                }
            } else {
                this.lastRecipes.remove(slot);
                this.activeRecipes.remove(slot);
                lastRecipe = null;
            }
        }
        if (lastRecipe == null) {
            IMachineRecipeList.RecipeEntry out = this.getOutputFor(((ItemStack)this.inventory.get(slot)).func_77946_l());
            if (out == null || this.isRecipeStillValid(out) == EnumActionResult.PASS) {
                this.activeRecipes.remove(slot);
                return null;
            }
            lastRecipe = out;
            this.lastRecipes.put(slot, (Object)out);
            this.activeRecipes.put(slot, (Object)out);
            this.handleModifiers(out);
        }
        if ((result = this.canFillRecipeIntoOutputs(lastRecipe.getOutput())) == EnumActionResult.SUCCESS) {
            this.activeRecipes.put(slot, (Object)lastRecipe);
            return lastRecipe;
        }
        if (result == EnumActionResult.PASS) {
            this.activeRecipes.remove(slot);
            return null;
        }
        if (this.hasEmptyOutput(slot)) {
            this.activeRecipes.put(slot, (Object)lastRecipe);
            return lastRecipe;
        }
        for (ItemStack output : lastRecipe.getOutput().getAllOutputs()) {
            for (int outputSlot : this.getOutputSlots()) {
                if (!StackUtil.isStackEqual((ItemStack)((ItemStack)this.inventory.get(outputSlot)), (ItemStack)output, (boolean)false, (boolean)true) || ((ItemStack)this.inventory.get(outputSlot)).func_190916_E() + output.func_190916_E() > ((ItemStack)this.inventory.get(outputSlot)).func_77976_d()) continue;
                this.activeRecipes.put(slot, (Object)lastRecipe);
                return lastRecipe;
            }
        }
        this.activeRecipes.remove(slot);
        return null;
    }

    protected EnumActionResult canFillRecipeIntoOutputs(MachineOutput output) {
        List result = output.getAllOutputs();
        for (int i = 0; i < result.size() && i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(2 + i);
            ItemStack extra = (ItemStack)result.get(i);
            if ((stack.func_190926_b() || StackUtil.isStackEqual((ItemStack)stack, (ItemStack)extra, (boolean)false, (boolean)true)) && stack.func_190916_E() + extra.func_190916_E() <= extra.func_77976_d()) continue;
            return EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    public void handleTank() {
        RangedInventoryWrapper output;
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)((ItemStack)this.inventory.get(5)));
        if (FluidHelper.hasFluid((IFluidHandler)containerFluidHandler, (FluidStack)FluidRegistry.getFluidStack((String)FluidRegistry.WATER.getName(), (int)1), (boolean)false) && this.waterTank.getFluidAmount() + FluidUtil.getFluidContained((ItemStack)((ItemStack)this.inventory.get((int)5))).amount <= this.waterTank.getCapacity() && FluidHelper.drainContainers((IFluidHandler)this.waterTank, (IHasInventory)this, (int)5, (IHasInventory)(output = new RangedInventoryWrapper((IHasInventory)this, new int[]{6})))) {
            this.getNetwork().updateTileGuiField((TileEntity)this, "tank");
            this.setStackInSlot(6, output.getStackInSlot(0));
        }
    }

    public void operateOnce(int slot, IRecipeInput input, MachineOutput output, List<IStackOutput> list) {
        List result = output.getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData());
        for (int i = 0; i < result.size(); ++i) {
            list.add((IStackOutput)new SimpleStackOutput((ItemStack)result.get(i), 2 + i % 3));
        }
        this.consumeInput(input);
        this.waterTank.drain(TileEntityThermalWasher.getRequiredWater(output), true);
    }

    public void consumeInput(IRecipeInput input) {
        if (!(input instanceof INullableRecipeInput) || !((ItemStack)this.inventory.get(1)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(1)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(1))) {
                this.inventory.set(1, (Object)((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(1)));
            } else {
                ((ItemStack)this.inventory.get(1)).func_190918_g(input.getAmount());
            }
        }
    }

    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper((IHasInventory)this, new int[]{2, 3, 4, 6});
    }

    public IHasInventory getInputInventory() {
        return new RangedInventoryWrapper((IHasInventory)this, new int[]{1}).setFilters(this.filter);
    }

    public FluidStack getFluid() {
        return this.waterTank.getFluid();
    }

    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField((TileEntity)this, "waterTank");
        this.notCheckRecipe.clear();
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(FluidRegistry.WATER, this.water), 10000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
            int toAdd = Math.min(resource.amount, this.maxWater - this.water);
            if (doFill) {
                this.water += toAdd;
                this.getNetwork().updateTileGuiField((TileEntity)this, "water");
            }
            return toAdd;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return resource != null && resource.getFluid() == FluidRegistry.WATER ? this.drain(resource.amount, doDrain) : null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int amount = Math.min(maxDrain, this.water);
        if (amount <= 0) {
            return null;
        }
        if (doDrain) {
            this.water -= amount;
            this.getNetwork().updateTileGuiField((TileEntity)this, "water");
        }
        return new FluidStack(FluidRegistry.WATER, amount);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("Tank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.waterTank.writeToNBT(this.getTag(nbt, "Tank"));
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.waterTank : super.getCapability(capability, facing));
    }

    protected EnumActionResult isRecipeStillValid(IMachineRecipeList.RecipeEntry entry) {
        if (this.waterTank.getFluidAmount() >= TileEntityThermalWasher.getRequiredWater(entry.getOutput())) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static int getRequiredWater(MachineOutput output) {
        if (output == null || output.getMetadata() == null) {
            return 0;
        }
        return output.getMetadata().func_74762_e("amount");
    }

    public boolean hasRightClick() {
        return true;
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing enumFacing, Side side) {
        FluidActionResult result;
        ItemStack playerStack = player.func_184586_b(hand);
        if (!playerStack.func_190926_b() && (result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this.waterTank, (int)(this.waterTank.getCapacity() - this.waterTank.getFluidAmount()), (EntityPlayer)player, (boolean)true)).isSuccess()) {
            playerStack.func_190918_g(1);
            ItemStack resultStack = result.getResult();
            if (!resultStack.func_190926_b() && !player.field_71071_by.func_70441_a(resultStack)) {
                player.func_71019_a(resultStack, false);
            }
            return true;
        }
        return false;
    }

    public boolean hasLeftClick() {
        return false;
    }

    public void onLeftClick(EntityPlayer entityPlayer, Side side) {
    }

    @Optional.Method(modid="gtclassic")
    public void getData(Map<String, Boolean> map) {
        FluidStack fluid = this.waterTank.getFluid();
        int amount = fluid != null ? fluid.amount : 0;
        map.put("Contains " + amount + " mb of Water", false);
    }
}

