/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.helpers.AENetworkProxy;
import appeng.util.Platform;
import io.github.phantamanta44.libnine.capability.impl.L9AspectInventory;
import io.github.phantamanta44.libnine.component.multiblock.IMultiBlockUnit;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockConnectable;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockCore;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockType;
import io.github.phantamanta44.libnine.tile.RegisterTile;
import io.github.phantamanta44.libnine.util.TriBool;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.data.serialization.IDatum;
import io.github.phantamanta44.libnine.util.nbt.ChainingTagCompound;
import io.github.phantamanta44.threng.block.BlockBigAssembler;
import io.github.phantamanta44.threng.multiblock.ThrEngMultiBlocks;
import io.github.phantamanta44.threng.tile.TileBigAssemblerPatternStore;
import io.github.phantamanta44.threng.tile.base.IBigAssemblerUnit;
import io.github.phantamanta44.threng.tile.base.IDroppableInventory;
import io.github.phantamanta44.threng.tile.base.TileAENetworked;
import io.github.phantamanta44.threng.util.AppEngUtils;
import io.github.phantamanta44.threng.util.InvUtils;
import io.github.phantamanta44.threng.util.ThrEngTextStyles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@RegisterTile(value="threng")
public class TileBigAssemblerCore
extends TileAENetworked
implements IBigAssemblerUnit,
ICraftingProvider,
IDroppableInventory {
    public static final int MAX_JOB_QUEUE = 64;
    private static final double ENERGY_PER_WORK = 16.0;
    public static final int WORK_PER_JOB = 16;
    public static final int MAX_EFFECTIVE_CPUS = 341;
    @AutoSerialize
    private final MultiBlockCore<IBigAssemblerUnit> multiBlock = new MultiBlockCore((IMultiBlockUnit)this, ThrEngMultiBlocks.BIG_ASSEMBLER);
    @AutoSerialize
    private final IDatum.OfInt cpuCount = IDatum.ofInt((int)0);
    @AutoSerialize
    private final L9AspectInventory craftingBuffer = new L9AspectInventory.Observable(576, (i, o, n) -> this.setDirty());
    @AutoSerialize(sync=false)
    private final L9AspectInventory outputBuffer = new L9AspectInventory.Observable(640, (i, o, n) -> this.setDirty());
    @AutoSerialize
    private final JobQueue jobQueue = new JobQueue();
    @AutoSerialize
    private final IDatum.OfInt work = IDatum.ofInt((int)0);
    private TriBool clientCachedFormStatus = TriBool.NONE;
    private boolean patternsDirty = false;
    @Nullable
    private List<TileBigAssemblerPatternStore> patternStoreCache = null;

    public TileBigAssemblerCore() {
        this.markRequiresSync();
        this.multiBlock.onFormationStatusChange(() -> {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            if (this.multiBlock.isFormed()) {
                int cpus = 0;
                for (MultiBlockConnectable comp : this.multiBlock) {
                    if (((IBigAssemblerUnit)comp.getUnit()).getWorldPos().getBlockState().func_177229_b(BlockBigAssembler.TYPE) != BlockBigAssembler.Type.MODULE_CPU) continue;
                    ++cpus;
                }
                this.cpuCount.setInt(cpus);
            } else {
                this.cpuCount.setInt(0);
            }
            this.patternStoreCache = null;
            this.notifyPatternUpdate();
            this.setDirty();
        });
    }

    @Override
    protected void initProxy(AENetworkProxy proxy) {
        proxy.setIdlePowerUsage(3.0);
        proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public int getCpuCount() {
        return this.cpuCount.getInt();
    }

    public int getJobCount() {
        return this.jobQueue.getOutstandingJobCount();
    }

    public int getWork() {
        return this.work.getInt();
    }

    public double getEnergyCost() {
        return 16.0 + (double)this.cpuCount.getInt();
    }

    public int getWorkRate() {
        return this.cpuCount.getInt() * 3 + 1;
    }

    @Nullable
    public IAssemblyJob getActiveJob() {
        return this.jobQueue.peek();
    }

    public IItemHandler getCraftingBuffer() {
        return this.craftingBuffer;
    }

    public List<TileBigAssemblerPatternStore> getPatternStores() {
        if (this.patternStoreCache == null) {
            this.patternStoreCache = new ArrayList<TileBigAssemblerPatternStore>();
            if (this.multiBlock.isFormed()) {
                for (MultiBlockConnectable comp : this.multiBlock) {
                    IBigAssemblerUnit unit = (IBigAssemblerUnit)comp.getUnit();
                    if (!(unit instanceof TileBigAssemblerPatternStore)) continue;
                    this.patternStoreCache.add((TileBigAssemblerPatternStore)unit);
                }
            }
        }
        return this.patternStoreCache;
    }

    public MultiBlockType<IBigAssemblerUnit> getMultiBlockType() {
        return ThrEngMultiBlocks.BIG_ASSEMBLER;
    }

    public MultiBlockConnectable<IBigAssemblerUnit> getMultiBlockConnection() {
        return this.multiBlock;
    }

    @Override
    @Nullable
    protected ItemStack getNetworkRepresentation() {
        return BlockBigAssembler.Type.CONTROLLER.newStack(1);
    }

    @Override
    public boolean isActive() {
        return this.multiBlock.isFormed();
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange event) {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @MENetworkEventSubscribe
    public void onNetworkChannelsChange(MENetworkChannelsChanged event) {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public void tryAssemble(EntityPlayer player) {
        TextComponentTranslation msg;
        if (this.multiBlock.isFormed()) {
            this.multiBlock.disconnect();
            msg = new TextComponentTranslation("threng.misc.notif.multiblock_unformed", new Object[0]);
            msg.func_150255_a(ThrEngTextStyles.SUCCESS);
        } else if (this.multiBlock.tryForm()) {
            msg = new TextComponentTranslation("threng.misc.notif.multiblock_formed", new Object[0]);
            msg.func_150255_a(ThrEngTextStyles.SUCCESS);
        } else {
            msg = new TextComponentTranslation("threng.misc.notif.multiblock_failed", new Object[0]);
            msg.func_150255_a(ThrEngTextStyles.FAILURE);
        }
        player.func_146105_b((ITextComponent)msg, true);
    }

    @Override
    public void collectDrops(Accrue<ItemStack> drops) {
        InvUtils.accrue(drops, new IItemHandler[]{this.craftingBuffer});
    }

    protected void tick() {
        if (!this.field_145850_b.field_72995_K) {
            this.aeGrid().ifPresent(grid -> {
                IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
                IMEMonitor storage = ((IStorageGrid)grid.getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                AppEngUtils.importItems((IItemHandlerModifiable)this.outputBuffer, (IMEMonitor<IAEItemStack>)storage, energy, this.actionSource);
                if (this.patternsDirty) {
                    grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
                    this.patternsDirty = false;
                }
                if (this.multiBlock.isFormed()) {
                    int jobs = this.jobQueue.getOutstandingJobCount();
                    if (jobs > 0) {
                        int currentWork = this.work.getInt();
                        double energyUnitCost = this.getEnergyCost();
                        double extracted = energy.extractAEPower(energyUnitCost * (double)Math.min(this.getWorkRate(), jobs * 16 - currentWork), Actionable.MODULATE, PowerMultiplier.CONFIG);
                        int workDone = (int)Math.ceil(extracted / energyUnitCost);
                        if (workDone > 0) {
                            currentWork += workDone;
                            while (currentWork >= 16) {
                                currentWork -= 16;
                                this.jobQueue.dispatchJob();
                            }
                            this.work.setInt(currentWork);
                            this.setDirty();
                        }
                    } else if (this.work.getInt() > 0) {
                        this.work.setInt(0);
                        this.setDirty();
                    }
                }
            });
        }
    }

    public void notifyPatternUpdate() {
        this.patternsDirty = true;
    }

    public void provideCrafting(ICraftingProviderHelper helper) {
        for (TileBigAssemblerPatternStore patternStore : this.getPatternStores()) {
            patternStore.providePatterns((ICraftingMedium)this, helper);
        }
    }

    public boolean pushPattern(ICraftingPatternDetails pattern, InventoryCrafting inv) {
        if (pattern.isCraftable() && !this.jobQueue.isFull()) {
            ItemStack output = pattern.getOutput(inv, this.func_145831_w());
            if (!output.func_190926_b()) {
                ItemStack[] remaining = new ItemStack[9];
                int remMax = Math.min(inv.func_70302_i_(), 9);
                for (int i = 0; i < remMax; ++i) {
                    remaining[i] = Platform.getContainerItem((ItemStack)inv.func_70301_a(i));
                }
                this.jobQueue.pushJob(inv, remaining, output);
            }
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return this.jobQueue.isFull();
    }

    public void deserBytes(ByteUtils.Reader data) {
        super.deserBytes(data);
        TriBool formStatus = TriBool.wrap((boolean)this.multiBlock.isFormed());
        if (this.clientCachedFormStatus != formStatus) {
            this.clientCachedFormStatus = formStatus;
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.patternStoreCache = null;
        }
    }

    public static interface IAssemblyJob {
        public int getJobIndex();

        public ItemStack getResult();
    }

    private class JobQueue
    implements ISerializable {
        private BitSet jobSlots = new BitSet(64);
        private final Deque<CraftingJob> queue = new ArrayDeque<CraftingJob>();

        private JobQueue() {
        }

        int getOutstandingJobCount() {
            return this.queue.size();
        }

        boolean isFull() {
            return this.queue.size() == 64;
        }

        @Nullable
        CraftingJob peek() {
            return this.queue.peek();
        }

        void pushJob(InventoryCrafting input, ItemStack[] remaining, ItemStack output) {
            CraftingJob job = new CraftingJob(this.jobSlots.nextClearBit(0), remaining, output);
            this.queue.offer(job);
            this.jobSlots.set(job.index);
            for (int i = 0; i < 9; ++i) {
                TileBigAssemblerCore.this.craftingBuffer.setStackInSlot(job.index * 9 + i, input.func_70301_a(i));
            }
        }

        void dispatchJob() {
            CraftingJob job = this.queue.peek();
            if (job != null) {
                int i;
                for (i = 0; i < 10; ++i) {
                    if (TileBigAssemblerCore.this.outputBuffer.getStackInSlot(job.index * 10 + i).func_190926_b()) continue;
                    return;
                }
                for (i = 0; i < 9; ++i) {
                    ItemStack stack = job.remaining[i];
                    if (!stack.func_190926_b()) {
                        TileBigAssemblerCore.this.outputBuffer.setStackInSlot(job.index * 10 + i, stack);
                    }
                    TileBigAssemblerCore.this.craftingBuffer.setStackInSlot(job.index * 9 + i, ItemStack.field_190927_a);
                }
                TileBigAssemblerCore.this.outputBuffer.setStackInSlot(job.index * 10 + 9, job.result);
                this.queue.pop();
                this.jobSlots.clear(job.index);
            }
        }

        public void serBytes(ByteUtils.Writer data) {
            byte[] jobSlotData = this.jobSlots.toByteArray();
            data.writeInt(jobSlotData.length).writeBytes(jobSlotData).writeInt(this.queue.size());
            for (CraftingJob job : this.queue) {
                data.writeInt(job.index);
                for (ItemStack remStack : job.remaining) {
                    data.writeItemStack(remStack);
                }
                data.writeItemStack(job.result);
            }
        }

        public void deserBytes(ByteUtils.Reader data) {
            this.jobSlots = BitSet.valueOf(data.readBytes(data.readInt()));
            this.queue.clear();
            for (int jobCount = data.readInt(); jobCount > 0; --jobCount) {
                this.queue.offer(new CraftingJob(data.readInt(), (ItemStack[])IntStream.range(0, 9).mapToObj(i -> data.readItemStack()).toArray(ItemStack[]::new), data.readItemStack()));
            }
        }

        public void serNBT(NBTTagCompound tag) {
            tag.func_74773_a("JobSlots", this.jobSlots.toByteArray());
            NBTTagList queueTag = new NBTTagList();
            for (CraftingJob job : this.queue) {
                queueTag.func_74742_a((NBTBase)new ChainingTagCompound().withInt("Index", job.index).withList("Remaining", Arrays.stream(job.remaining).map(ItemStack::serializeNBT).collect(Collectors.toList())).withItemStack("Result", job.result));
            }
            tag.func_74782_a("Queue", (NBTBase)queueTag);
        }

        public void deserNBT(NBTTagCompound tag) {
            this.jobSlots = BitSet.valueOf(tag.func_74770_j("JobSlots"));
            this.queue.clear();
            for (NBTBase jobTag0 : tag.func_150295_c("Queue", 10)) {
                NBTTagCompound jobTag = (NBTTagCompound)jobTag0;
                NBTTagList remTag = jobTag.func_150295_c("Remaining", 10);
                ItemStack[] rem = new ItemStack[9];
                for (int i = 0; i < remTag.func_74745_c(); ++i) {
                    rem[i] = new ItemStack(remTag.func_150305_b(i));
                }
                this.queue.offer(new CraftingJob(jobTag.func_74762_e("Index"), rem, new ItemStack(jobTag.func_74775_l("Result"))));
            }
        }

        private class CraftingJob
        implements IAssemblyJob {
            final int index;
            final ItemStack[] remaining;
            final ItemStack result;

            CraftingJob(int index, ItemStack[] remaining, ItemStack result) {
                this.index = index;
                this.remaining = remaining;
                this.result = result;
            }

            @Override
            public int getJobIndex() {
                return this.index;
            }

            @Override
            public ItemStack getResult() {
                return this.result;
            }
        }
    }
}

