/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile;

import io.github.phantamanta44.libnine.capability.impl.L9AspectInventory;
import io.github.phantamanta44.libnine.capability.impl.L9AspectSlot;
import io.github.phantamanta44.libnine.capability.provider.CapabilityBrokerDirPredicated;
import io.github.phantamanta44.libnine.recipe.output.ItemStackOutput;
import io.github.phantamanta44.libnine.tile.RegisterTile;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.tuple.ITriple;
import io.github.phantamanta44.libnine.util.world.IAllocableSides;
import io.github.phantamanta44.libnine.util.world.SideAlloc;
import io.github.phantamanta44.threng.recipe.AggRecipe;
import io.github.phantamanta44.threng.recipe.component.TriItemInput;
import io.github.phantamanta44.threng.tile.base.TileSimpleProcessor;
import io.github.phantamanta44.threng.util.InvUtils;
import io.github.phantamanta44.threng.util.SlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@RegisterTile(value="threng")
public class TileAggregator
extends TileSimpleProcessor<ITriple<ItemStack, ItemStack, ItemStack>, ItemStack, TriItemInput, ItemStackOutput, AggRecipe> {
    private static final int ENERGY_MAX = 100000;
    @AutoSerialize(sync=false)
    private final L9AspectInventory invInput = new L9AspectInventory.Observable(3, (s, o, n) -> this.markWorkStateDirty());
    @AutoSerialize(sync=false)
    private final L9AspectSlot slotOutput = new L9AspectSlot.Observable(is -> false, (s, o, n) -> this.markWorkStateDirty());
    @AutoSerialize
    private final SideAlloc<SlotType.BasicIO> sides = new SideAlloc((Enum)SlotType.BasicIO.NONE, this::getFrontFace);

    public TileAggregator() {
        super(AggRecipe.class, 100000);
        this.setInitialized();
    }

    @Override
    protected CapabilityBrokerDirPredicated initCapabilities() {
        return super.initCapabilities().with(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)this.invInput, this.sides.getPredicate((Enum)SlotType.BasicIO.INPUT)).with(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)this.slotOutput, this.sides.getPredicate((Enum)SlotType.BasicIO.OUTPUT));
    }

    @Override
    public IAllocableSides<SlotType.BasicIO> getSidedIo() {
        return this.sides;
    }

    @Override
    protected ITriple<ItemStack, ItemStack, ItemStack> getInput() {
        return ITriple.of((Object)this.invInput.getStackInSlot(0), (Object)this.invInput.getStackInSlot(1), (Object)this.invInput.getStackInSlot(2));
    }

    @Override
    protected ItemStack getOutputEnvironment() {
        return this.slotOutput.getStackInSlot();
    }

    @Override
    protected void acceptOutput(ITriple<ItemStack, ItemStack, ItemStack> newInputs, ItemStackOutput output) {
        this.invInput.setStackInSlot(0, (ItemStack)newInputs.getA());
        this.invInput.setStackInSlot(1, (ItemStack)newInputs.getB());
        this.invInput.setStackInSlot(2, (ItemStack)newInputs.getC());
        if (this.slotOutput.getStackInSlot().func_190926_b()) {
            this.slotOutput.setStackInSlot(output.getOutput().func_77946_l());
        } else {
            this.slotOutput.getStackInSlot().func_190917_f(output.getOutput().func_190916_E());
        }
    }

    public IItemHandler getInputSlots() {
        return this.invInput;
    }

    public IItemHandler getOutputSlot() {
        return this.slotOutput;
    }

    @Override
    public void collectDrops(Accrue<ItemStack> drops) {
        super.collectDrops(drops);
        InvUtils.accrue(drops, new IItemHandler[]{this.invInput, this.slotOutput});
    }
}

