/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.inventory;

import io.github.phantamanta44.libnine.gui.L9Container;
import io.github.phantamanta44.threng.tile.TileBigAssemblerCore;
import io.github.phantamanta44.threng.tile.TileBigAssemblerPatternStore;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerBigAssembler
extends L9Container {
    private final TileBigAssemblerCore tile;
    private final Page[] pages;

    public ContainerBigAssembler(EntityPlayer player, World world, int x, int y, int z) {
        this(player.field_71071_by, (TileBigAssemblerCore)Objects.requireNonNull(world.func_175625_s(new BlockPos(x, y, z))));
    }

    public ContainerBigAssembler(InventoryPlayer ipl, TileBigAssemblerCore tile) {
        super(ipl, 217);
        this.tile = tile;
        List<TileBigAssemblerPatternStore> patternStores = tile.getPatternStores();
        this.pages = new Page[patternStores.size()];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = new Page(patternStores.get(i).getPatternInventory());
        }
    }

    public TileBigAssemblerCore getAssemblerCore() {
        return this.tile;
    }

    public Page getPage(int pageNum) {
        return this.pages[pageNum];
    }

    public int getPageCount() {
        return this.pages.length;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tile.isActive();
    }

    public class Page {
        private boolean active = true;

        Page(IItemHandlerModifiable patternInv) {
            for (int row = 0; row < 4; ++row) {
                for (int col = 0; col < 9; ++col) {
                    int index = row * 9 + col;
                    ContainerBigAssembler.this.func_75146_a((Slot)new SlotPage(patternInv, index, 8 + col * 18, 18 + row * 18));
                }
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        private class SlotPage
        extends SlotItemHandler {
            public SlotPage(IItemHandlerModifiable patternInv, int index, int posX, int posY) {
                super((IItemHandler)patternInv, index, posX, posY);
            }

            public boolean func_111238_b() {
                return Page.this.active;
            }
        }
    }
}

