/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.integration.jei;

import crafttweaker.annotations.ModOnly;
import io.github.phantamanta44.libnine.util.IDisplayableMatcher;
import io.github.phantamanta44.threng.constant.ResConst;
import io.github.phantamanta44.threng.integration.jei.base.ThrEngJeiCategory;
import io.github.phantamanta44.threng.recipe.AggRecipe;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;

@ModOnly(value="jei")
class JeiRecipeTypeAgg
extends ThrEngJeiCategory<AggRecipe, Recipe> {
    JeiRecipeTypeAgg() {
        super(AggRecipe.class, "threng.agg", "threng.int.jei.category.aggregator", ResConst.INT_JEI_CAT_AGG_BG);
    }

    public void setRecipe(IRecipeLayout layout, Recipe recipe, IIngredients ingredients) {
        for (int i = 0; i < 3; ++i) {
            layout.getItemStacks().init(i, true, 20 + 20 * i, 27);
        }
        layout.getItemStacks().init(3, false, 120, 27);
        layout.getItemStacks().set(ingredients);
    }

    @Override
    public Recipe wrap(AggRecipe recipe) {
        return new Recipe(recipe);
    }

    static class Recipe
    implements IRecipeWrapper {
        private final AggRecipe recipe;

        Recipe(AggRecipe recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.recipe.input().getInputs().stream().map(IDisplayableMatcher::getVisuals).collect(Collectors.toList()));
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.getOutput().getOutput());
        }
    }
}

