/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.client.gui.component;

import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import io.github.phantamanta44.libnine.util.render.GuiUtils;
import io.github.phantamanta44.libnine.util.world.BlockSide;
import io.github.phantamanta44.libnine.util.world.IAllocableSides;
import io.github.phantamanta44.threng.constant.LangConst;
import io.github.phantamanta44.threng.constant.ResConst;
import io.github.phantamanta44.threng.util.SlotType;
import java.util.Arrays;
import net.minecraft.util.text.TextFormatting;

public class GuiComponentSidedIo
extends GuiComponent {
    private static final BlockSide[] FACE_SIDES = new BlockSide[]{BlockSide.UP, BlockSide.LEFT, BlockSide.FRONT, BlockSide.RIGHT, BlockSide.DOWN, BlockSide.BACK};
    private static final int[] FACE_X_COORDS = new int[]{6, 1, 6, 11, 6, 11};
    private static final int[] FACE_Y_COORDS = new int[]{1, 6, 6, 6, 11, 11};
    private final IAllocableSides<SlotType.BasicIO> sides;

    public GuiComponentSidedIo(IAllocableSides<SlotType.BasicIO> sides, int x, int y) {
        super(x, y, 17, 17);
        this.sides = sides;
    }

    public GuiComponentSidedIo(IAllocableSides<SlotType.BasicIO> sides) {
        this(sides, 146, 7);
    }

    public void render(float partialTicks, int mX, int mY, boolean mouseOver) {
        ResConst.GUI_COMP_SIDE_IO_BG.draw(this.x, this.y);
        block4: for (int i = 0; i < FACE_SIDES.length; ++i) {
            switch ((SlotType.BasicIO)this.sides.getFace(FACE_SIDES[i])) {
                case INPUT: {
                    ResConst.GUI_COMP_SIDE_IO_IN.draw(this.x + FACE_X_COORDS[i], this.y + FACE_Y_COORDS[i]);
                    continue block4;
                }
                case OUTPUT: {
                    ResConst.GUI_COMP_SIDE_IO_OUT.draw(this.x + FACE_X_COORDS[i], this.y + FACE_Y_COORDS[i]);
                }
            }
        }
    }

    public void renderTooltip(float partialTicks, int mX, int mY) {
        for (int i = 0; i < FACE_SIDES.length; ++i) {
            if (!GuiUtils.isMouseOver((int)(this.x + FACE_X_COORDS[i]), (int)(this.y + FACE_Y_COORDS[i]), (int)5, (int)5, (int)mX, (int)mY)) continue;
            this.drawTooltip(Arrays.asList(TextFormatting.YELLOW + LangConst.getSideName(FACE_SIDES[i]), LangConst.getIoName((SlotType.BasicIO)this.sides.getFace(FACE_SIDES[i]))), mX, mY);
            break;
        }
    }

    public boolean onClick(int mX, int mY, int button, boolean mouseOver) {
        if (button <= 1) {
            for (int i = 0; i < FACE_SIDES.length; ++i) {
                if (!GuiUtils.isMouseOver((int)(this.x + FACE_X_COORDS[i]), (int)(this.y + FACE_Y_COORDS[i]), (int)5, (int)5, (int)mX, (int)mY)) continue;
                if (button == 0) {
                    SlotType.BasicIO[] ioTypes = SlotType.BasicIO.values();
                    this.sides.setFace(FACE_SIDES[i], (Enum)ioTypes[(((SlotType.BasicIO)this.sides.getFace(FACE_SIDES[i])).ordinal() + 1) % ioTypes.length]);
                } else if (button == 1) {
                    SlotType.BasicIO[] ioTypes = SlotType.BasicIO.values();
                    int newOrdinal = ((SlotType.BasicIO)this.sides.getFace(FACE_SIDES[i])).ordinal() - 1;
                    if (newOrdinal == -1) {
                        newOrdinal = ioTypes.length - 1;
                    }
                    this.sides.setFace(FACE_SIDES[i], (Enum)ioTypes[newOrdinal]);
                }
                GuiComponentSidedIo.playClickSound();
                return true;
            }
        }
        return false;
    }
}

