/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.block;

import appeng.util.Platform;
import io.github.phantamanta44.libnine.block.L9BlockStated;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockCore;
import io.github.phantamanta44.libnine.item.L9ItemBlock;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.world.WorldUtils;
import io.github.phantamanta44.threng.ThrEng;
import io.github.phantamanta44.threng.block.ThrEngBlocks;
import io.github.phantamanta44.threng.block.ThrEngProps;
import io.github.phantamanta44.threng.inventory.ThrEngGuis;
import io.github.phantamanta44.threng.item.block.ItemBlockBigAssembler;
import io.github.phantamanta44.threng.tile.TileBigAssemblerCore;
import io.github.phantamanta44.threng.tile.TileBigAssemblerPart;
import io.github.phantamanta44.threng.tile.TileBigAssemblerPatternStore;
import io.github.phantamanta44.threng.tile.base.IActivable;
import io.github.phantamanta44.threng.tile.base.IBigAssemblerUnit;
import io.github.phantamanta44.threng.tile.base.IDroppableInventory;
import io.github.phantamanta44.threng.tile.base.TileAENetworked;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBigAssembler
extends L9BlockStated {
    public static final IProperty<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockBigAssembler() {
        super("big_assembler", Material.field_151573_f);
        this.func_149711_c(6.0f);
        this.setTileFactory((w, m) -> Type.getForMeta(m).createTileEntity());
    }

    protected void accrueProperties(Accrue<IProperty<?>> props) {
        props.accept(TYPE);
    }

    protected void accrueVolatileProperties(Accrue<IProperty<?>> props) {
        props.accept((Object)ThrEngProps.ACTIVE);
    }

    protected L9ItemBlock initItemBlock() {
        return new ItemBlockBigAssembler(this);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)ThrEngProps.ACTIVE, (Comparable)Boolean.valueOf(((IActivable)Objects.requireNonNull(this.getTileEntity(world, pos))).isActive()));
    }

    public int func_149750_m(IBlockState state) {
        switch ((Type)((Object)state.func_177229_b(TYPE))) {
            case MODULE_CPU: 
            case MODULE_PATTERN: {
                return 10;
            }
        }
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = Objects.requireNonNull(this.getTileEntity((IBlockAccess)world, pos));
        if (tile instanceof TileAENetworked && placer instanceof EntityPlayer) {
            ((TileAENetworked)tile).getProxy().setOwner((EntityPlayer)placer);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        MultiBlockCore core;
        ItemStack held = player.func_184586_b(hand);
        if (Platform.isWrench((EntityPlayer)player, (ItemStack)held, (BlockPos)pos) && player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
            }
            return true;
        }
        IBigAssemblerUnit tile = (IBigAssemblerUnit)this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null && (core = tile.getMultiBlockConnection().getCore()) != null) {
            if (((IBigAssemblerUnit)core.getUnit()).isActive()) {
                if (!world.field_72995_K) {
                    ThrEng.INSTANCE.getGuiHandler().openGui(player, ThrEngGuis.BIG_ASSEMBLER, ((IBigAssemblerUnit)core.getUnit()).getWorldPos());
                }
                return true;
            }
            if (tile instanceof TileBigAssemblerCore) {
                if (!world.field_72995_K) {
                    ((TileBigAssemblerCore)tile).tryAssemble(player);
                }
                return true;
            }
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null) {
            ((IBigAssemblerUnit)tile).getMultiBlockConnection().disconnect();
            if (tile instanceof IDroppableInventory) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                ((IDroppableInventory)tile).collectDrops((Accrue<ItemStack>)new Accrue(drops));
                drops.forEach(stack -> WorldUtils.dropItem((World)world, (BlockPos)pos, (ItemStack)stack));
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public static enum Type implements IStringSerializable
    {
        FRAME(TileBigAssemblerPart::new),
        VENT(TileBigAssemblerPart::new),
        CONTROLLER(TileBigAssemblerCore::new),
        MODULE_PATTERN(TileBigAssemblerPatternStore::new),
        MODULE_CPU(TileBigAssemblerPart::new);

        private static final Type[] VALUES;
        private final Supplier<TileEntity> tileFactory;

        public static Type getForMeta(int meta) {
            return VALUES[meta];
        }

        private Type(Supplier<TileEntity> tileFactory) {
            this.tileFactory = tileFactory;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public int getMeta() {
            return this.ordinal();
        }

        public ItemStack newStack(int count) {
            return new ItemStack((Block)ThrEngBlocks.BIG_ASSEMBLER, count, this.getMeta());
        }

        TileEntity createTileEntity() {
            return this.tileFactory.get();
        }

        static {
            VALUES = Type.values();
        }
    }
}

