/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.rendering.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.block.totem.BlockTotemPole;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.item.equipment.ItemTotemWhittlingKnife;

public class ModelTotemPole
implements IModel {
    private final IModel blankModel;
    private final Map<TotemEffect, IModel> totemModels;

    public ModelTotemPole(IModel blankModel, Map<TotemEffect, IModel> totemModels) {
        this.blankModel = blankModel;
        this.totemModels = totemModels;
    }

    public ModelTotemPole() {
        this.blankModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("totemic", "block/totem_pole_blank"));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TotemEffect totem : TotemicRegistries.totemEffects()) {
            ResourceLocation name = totem.getRegistryName();
            builder.put((Object)totem, (Object)ModelLoaderRegistry.getModelOrLogError((ResourceLocation)new ResourceLocation(name.func_110624_b(), "block/totem_pole_" + name.func_110623_a()), (String)("Could not load Totem Pole model for " + name)));
        }
        this.totemModels = builder.build();
    }

    public Collection<ResourceLocation> getDependencies() {
        HashSet<ResourceLocation> deps = new HashSet<ResourceLocation>();
        deps.addAll(this.blankModel.getDependencies());
        for (IModel model : this.totemModels.values()) {
            deps.addAll(model.getDependencies());
        }
        return deps;
    }

    public Collection<ResourceLocation> getTextures() {
        HashSet<ResourceLocation> textures = new HashSet<ResourceLocation>();
        textures.addAll(this.blankModel.getTextures());
        for (IModel model : this.totemModels.values()) {
            textures.addAll(model.getTextures());
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Map bakedTotemModels = Maps.transformEntries(this.totemModels, (totem, model) -> {
            if (totem == ModContent.buffaloTotem) {
                return model.bake((IModelState)new ModelStateComposition(state, (IModelState)ModelRotation.X0_Y90), format, bakedTextureGetter);
            }
            return model.bake(state, format, bakedTextureGetter);
        });
        return new BakedTotemPole(this.blankModel.bake(state, format, bakedTextureGetter), (ImmutableMap<TotemEffect, IBakedModel>)ImmutableMap.copyOf((Map)bakedTotemModels));
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        return new ModelTotemPole(this.blankModel.retexture(textures), (Map<TotemEffect, IModel>)ImmutableMap.copyOf((Map)Maps.transformValues(this.totemModels, model -> model.retexture(textures))));
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("totemic") && modelLocation.func_110623_a().equals("models/block/totem_pole");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new ModelTotemPole();
        }
    }

    public static final class BakedTotemPole
    extends BakedModelWrapper<IBakedModel> {
        private final ImmutableMap<TotemEffect, IBakedModel> bakedTotemModels;
        private final ItemOverrideList overrideList = new ItemOverrideList(Collections.emptyList()){

            public IBakedModel handleItemState(IBakedModel previousModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                TotemEffect effect = ItemTotemWhittlingKnife.getCarvingEffect(stack);
                return effect != null ? (IBakedModel)bakedTotemModels.get((Object)effect) : originalModel;
            }
        };

        public BakedTotemPole(IBakedModel bakedBlankModel, ImmutableMap<TotemEffect, IBakedModel> bakedTotemModels) {
            super(bakedBlankModel);
            this.bakedTotemModels = bakedTotemModels;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            TotemEffect effect;
            if (state instanceof IExtendedBlockState && (effect = (TotemEffect)((Object)((IExtendedBlockState)state).getValue(BlockTotemPole.TOTEM))) != null) {
                return ((IBakedModel)this.bakedTotemModels.get((Object)effect)).func_188616_a(state, side, rand);
            }
            return this.originalModel.func_188616_a(state, side, rand);
        }

        public ItemOverrideList func_188617_f() {
            return this.overrideList;
        }
    }
}

