/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.miniaturization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import org.dave.compactmachines3.world.ProxyWorld;
import org.dave.compactmachines3.world.data.provider.AbstractExtraTileDataProvider;
import org.dave.compactmachines3.world.data.provider.ExtraTileDataProviderRegistry;

public class MultiblockRecipe {
    private String name;
    private String[][][] variantMap;
    private String[][][] map;
    private String[][][] map90;
    private String[][][] map180;
    private String[][][] map270;
    private List<BlockPos> mapAsBlockPos;
    private HashMap<String, IBlockState> reference;
    private HashMap<String, Integer> referenceCount;
    private HashMap<String, Boolean> referenceIgnoresMeta;
    private HashMap<String, NBTTagCompound> referenceTags;
    private HashMap<String, ItemStack> referenceStacks;
    private BlockPos minPos;
    private BlockPos maxPos;
    private ItemStack targetStack;
    private Item catalyst;
    private int catalystMeta;
    private NBTTagCompound catalystNbt;
    private int count;
    private int ticks;
    private boolean symmetrical;

    public MultiblockRecipe(String name, ItemStack targetStack, Item catalyst, int catalystMeta, NBTTagCompound catalystNbt, boolean symmetrical, int ticks) {
        this.name = name;
        this.reference = new HashMap();
        this.referenceCount = new HashMap();
        this.referenceIgnoresMeta = new HashMap();
        this.referenceTags = new HashMap();
        this.referenceStacks = new HashMap();
        this.targetStack = targetStack;
        this.catalyst = catalyst;
        this.catalystMeta = catalystMeta;
        this.catalystNbt = catalystNbt;
        this.symmetrical = symmetrical;
        this.ticks = ticks;
    }

    public void addBlockReference(String ref, IBlockState state) {
        this.reference.put(ref, state);
    }

    public void addBlockVariation(String ref, NBTTagCompound tag) {
        this.referenceTags.put(ref, tag);
    }

    public void setIgnoreMeta(String ref, boolean value) {
        this.referenceIgnoresMeta.put(ref, value);
    }

    public void setReferenceStack(String ref, ItemStack stack) {
        this.referenceStacks.put(ref, stack);
    }

    public int getTicks() {
        return this.ticks;
    }

    public String getName() {
        return this.name;
    }

    public List<ItemStack> getRequiredItemStacks() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (String ref : this.reference.keySet()) {
            IBlockState state = this.reference.get(ref);
            int count = this.referenceCount.getOrDefault(ref, 0);
            if (count == 0) continue;
            if (this.referenceStacks.containsKey(ref)) {
                result.add(this.referenceStacks.get(ref).func_77946_l());
                continue;
            }
            if (state.func_177230_c() == Blocks.field_150488_af) {
                result.add(new ItemStack(Items.field_151137_ax, count));
                continue;
            }
            if (this.referenceIgnoresMeta.getOrDefault(ref, false).booleanValue()) {
                result.add(new ItemStack(state.func_177230_c(), count, 0));
                continue;
            }
            result.add(new ItemStack(state.func_177230_c(), count, state.func_177230_c().func_176201_c(state)));
        }
        return result;
    }

    public void setVariantMap(String[][][] variantMap) {
        this.variantMap = variantMap;
    }

    public void setPositionMap(String[][][] map) {
        this.map = map;
        if (!this.symmetrical) {
            this.map90 = this.rotateMapCW(this.map);
            this.map180 = this.rotateMapCW(this.map90);
            this.map270 = this.rotateMapCW(this.map180);
        }
        this.mapAsBlockPos = new ArrayList<BlockPos>();
        this.count = 0;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (int y = 0; y < map.length; ++y) {
            for (int z = 0; z < map[y].length; ++z) {
                for (int x = 0; x < map[y][z].length; ++x) {
                    String content = map[y][z][x];
                    if (content.equals("_")) continue;
                    this.referenceCount.put(content, this.referenceCount.getOrDefault(content, 0) + 1);
                    minY = Math.min(minY, y);
                    minZ = Math.min(minZ, z);
                    minX = Math.min(minX, x);
                    maxY = Math.max(maxY, y);
                    maxZ = Math.max(maxZ, z);
                    maxX = Math.max(maxX, x);
                    this.mapAsBlockPos.add(new BlockPos(x, y, z));
                    ++this.count;
                }
            }
        }
        this.minPos = new BlockPos(minX, minY, minZ);
        this.maxPos = new BlockPos(maxX, maxY, maxZ);
    }

    public IBlockAccess getBlockAccess(final ProxyWorld proxyWorld) {
        return new IBlockAccess(){

            @Nullable
            public TileEntity func_175625_s(BlockPos pos) {
                IBlockState state = this.func_180495_p(pos);
                if (state.func_177230_c().hasTileEntity(state)) {
                    NBTTagCompound nbt;
                    TileEntity tileentity = state.func_177230_c().createTileEntity((World)proxyWorld, state);
                    tileentity.func_145834_a((World)proxyWorld);
                    if (tileentity != null && (nbt = MultiblockRecipe.this.getVariantAtBlockPos(pos)) != null) {
                        tileentity.func_145839_a(nbt);
                        for (AbstractExtraTileDataProvider provider : ExtraTileDataProviderRegistry.getDataProviders(tileentity)) {
                            String tagName = String.format("cm3_extra:%s", provider.getName());
                            if (!nbt.func_74764_b(tagName)) continue;
                            provider.readExtraData(tileentity, (NBTTagCompound)nbt.func_74781_a(tagName));
                        }
                    }
                    return tileentity;
                }
                return null;
            }

            public int func_175626_b(BlockPos pos, int lightValue) {
                return 255;
            }

            public IBlockState func_180495_p(BlockPos pos) {
                return MultiblockRecipe.this.getStateAtBlockPos(pos);
            }

            public boolean func_175623_d(BlockPos pos) {
                IBlockState blockState = this.func_180495_p(pos);
                return blockState.func_177230_c().isAir(blockState, (IBlockAccess)this, pos);
            }

            public Biome func_180494_b(BlockPos pos) {
                return Biomes.field_76772_c;
            }

            public int func_175627_a(BlockPos pos, EnumFacing direction) {
                return 0;
            }

            public WorldType func_175624_G() {
                return WorldType.field_77138_c;
            }

            public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
                return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
            }
        };
    }

    public boolean tryCrafting(World world, List<BlockPos> insideBlocks) {
        return this.tryCrafting(world, insideBlocks, null);
    }

    public boolean tryCrafting(World world, List<BlockPos> insideBlocks, ItemStack itemStack) {
        if (insideBlocks.size() != this.count) {
            return false;
        }
        if (itemStack != null) {
            boolean nbtMatches;
            boolean itemMatches = this.catalyst == itemStack.func_77973_b();
            boolean metaMatches = this.catalystMeta == itemStack.func_77960_j();
            boolean bl = nbtMatches = this.catalystNbt == null || NBTUtil.func_181123_a((NBTBase)this.catalystNbt, (NBTBase)itemStack.func_77978_p(), (boolean)false);
            if (!(itemMatches && metaMatches && nbtMatches)) {
                return false;
            }
        }
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        for (BlockPos pos : insideBlocks) {
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() < minZ) {
                minZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() >= minX) continue;
            minX = pos.func_177958_n();
        }
        if (this.symmetrical) {
            return this.testRotation(world, insideBlocks, minX, minY, minZ, this.map);
        }
        return this.testRotation(world, insideBlocks, minX, minY, minZ, this.map) || this.testRotation(world, insideBlocks, minX, minY, minZ, this.map90) || this.testRotation(world, insideBlocks, minX, minY, minZ, this.map180) || this.testRotation(world, insideBlocks, minX, minY, minZ, this.map270);
    }

    private boolean testRotation(World world, List<BlockPos> insideBlocks, int minX, int minY, int minZ, String[][][] map) {
        for (BlockPos pos : insideBlocks) {
            BlockPos relativePos = pos.func_177982_a(-minX, -minY, -minZ);
            int y = relativePos.func_177956_o();
            int z = relativePos.func_177952_p();
            int x = relativePos.func_177958_n();
            if (y < 0 || y >= map.length) {
                return false;
            }
            if (z < 0 || z >= map[y].length) {
                return false;
            }
            if (x < 0 || x >= map[y][z].length) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            if (map[map.length - y - 1][z][x].equals("_") && state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) continue;
            IBlockState wanted = this.reference.get(map[y][z][x]);
            if (wanted == null || state.func_177230_c() != wanted.func_177230_c()) {
                return false;
            }
            if (this.referenceIgnoresMeta.getOrDefault(map[y][z][x], false).booleanValue() || state.func_177230_c().func_176201_c(state) == wanted.func_177230_c().func_176201_c(wanted)) continue;
            return false;
        }
        return true;
    }

    private String[][][] rotateMapCW(String[][][] map) {
        String[][][] ret = new String[map.length][][];
        for (int y = 0; y < map.length; ++y) {
            int M = map[y].length;
            int N = map[y][0].length;
            String[][] slice = new String[N][M];
            for (int r = 0; r < M; ++r) {
                for (int c = 0; c < N; ++c) {
                    slice[c][M - 1 - r] = map[y][r][c];
                }
            }
            ret[y] = slice;
        }
        return ret;
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    public String getDimensionsString() {
        return String.format("%dx%dx%d", this.getWidth(), this.getHeight(), this.getDepth());
    }

    public int getWidth() {
        return this.getMaxPos().func_177958_n() - this.getMinPos().func_177958_n() + 1;
    }

    public int getHeight() {
        return this.getMaxPos().func_177956_o() - this.getMinPos().func_177956_o() + 1;
    }

    public int getDepth() {
        return this.getMaxPos().func_177952_p() - this.getMinPos().func_177952_p() + 1;
    }

    public ItemStack getCatalystStack() {
        ItemStack result = new ItemStack(this.catalyst, 1, this.catalystMeta);
        if (this.catalystNbt != null) {
            result.func_77982_d(this.catalystNbt.func_74737_b());
        }
        return result;
    }

    public ItemStack getTargetStack() {
        return this.targetStack.func_77946_l();
    }

    public IBlockState getStateAtBlockPos(BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= this.map.length) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (pos.func_177952_p() < 0 || pos.func_177952_p() >= this.map[pos.func_177956_o()].length) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (pos.func_177958_n() < 0 || pos.func_177958_n() >= this.map[pos.func_177956_o()][pos.func_177952_p()].length) {
            return Blocks.field_150350_a.func_176223_P();
        }
        String ref = this.map[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()];
        return this.reference.getOrDefault(ref, Blocks.field_150350_a.func_176223_P());
    }

    public NBTTagCompound getVariantAtBlockPos(BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= this.map.length) {
            return null;
        }
        if (pos.func_177952_p() < 0 || pos.func_177952_p() >= this.map[pos.func_177956_o()].length) {
            return null;
        }
        if (pos.func_177958_n() < 0 || pos.func_177958_n() >= this.map[pos.func_177956_o()][pos.func_177952_p()].length) {
            return null;
        }
        String variant = this.variantMap[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()];
        return this.referenceTags.getOrDefault(variant, null);
    }

    public List<BlockPos> getShapeAsBlockPosList() {
        return this.mapAsBlockPos;
    }
}

