/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.harvest;

import net.minecraft.item.Item;
import tyra314.toolprogression.api.OverwrittenContent;
import tyra314.toolprogression.config.ConfigHandler;

public class MaterialOverwrite {
    final int harvestLevel;

    public MaterialOverwrite(int harvestLevel) {
        this.harvestLevel = harvestLevel;
    }

    public static MaterialOverwrite readFromConfig(String config) {
        return new MaterialOverwrite(Integer.parseInt(config));
    }

    public static void applyToMaterial(Item.ToolMaterial mat) {
        MaterialOverwrite overwrite = ConfigHandler.matOverwrites.get(mat.name().toLowerCase());
        if (overwrite != null) {
            overwrite.applyTo(mat);
        }
        OverwrittenContent.materials.put(mat, overwrite);
    }

    public String getConfig() {
        return String.valueOf(this.harvestLevel);
    }

    public void applyTo(Item.ToolMaterial mat) {
        mat.field_78001_f = this.harvestLevel;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }
}

