/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.command.subcommand;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemTool;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import tyra314.toolprogression.command.SubCommand;
import tyra314.toolprogression.compat.tconstruct.TiCHelper;
import tyra314.toolprogression.compat.tconstruct.TiCMiningLevels;
import tyra314.toolprogression.compat.top.TOPHelper;
import tyra314.toolprogression.config.ConfigHandler;
import tyra314.toolprogression.harvest.BlockHelper;
import tyra314.toolprogression.harvest.MaterialOverwrite;
import tyra314.toolprogression.harvest.ToolHelper;

public class Reload
extends SubCommand {
    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public boolean handleCommand(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        ConfigHandler.readBaseConfig();
        IForgeRegistry block_registry = GameRegistry.findRegistry(Block.class);
        for (Block block : block_registry) {
            BlockHelper.applyToAll(block);
        }
        IForgeRegistry item_registry = GameRegistry.findRegistry(Item.class);
        for (Item item : item_registry) {
            if (!(item instanceof ItemTool) && !(item instanceof ItemHoe)) continue;
            ToolHelper.applyToItem(item);
        }
        for (Item.ToolMaterial mat : Item.ToolMaterial.values()) {
            MaterialOverwrite.applyToMaterial(mat);
        }
        if (TiCHelper.isLoaded()) {
            TiCMiningLevels.overwriteMiningLevels();
        }
        if (TOPHelper.isLoaded() && ConfigHandler.top_compat) {
            TOPHelper.overwriteHarvestLevels();
        }
        this.sendMessage(sender, "configuration reloaded.");
        return true;
    }

    @Override
    @Nonnull
    public List<String> provideCompletions(String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1 && this.getName().startsWith(args[0])) {
            completions.add(this.getName());
        }
        return completions;
    }

    @Override
    @Nonnull
    public String getSynopsis() {
        return this.getName();
    }
}

