/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2classictweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.recipe.IRecipeInput;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import trinsdar.ic2classictweaker.CraftTweakerActions;
import trinsdar.ic2classictweaker.IC2RecipeInputs;

@ModOnly(value="ic2")
@ZenClass(value="mods.ic2.CanningMachine")
@ZenRegister
public class CanningMachineSupport {
    @ZenMethod
    public static void registerItemsForEffect(int id, IItemStack ... input) {
        CraftTweakerActions.apply(new RegisterItemsForEffectAction(id, CraftTweakerMC.getItemStacks((IItemStack[])input)));
    }

    @ZenMethod
    public static void deleteEffectId(int id, boolean deleteItems) {
        CraftTweakerActions.apply(new DeleteEffectIdAction(id, deleteItems));
    }

    @ZenMethod
    public static void registerFuelValue(int value, IItemStack input) {
        CraftTweakerActions.apply(new RegisterFuelValueAction(value, CraftTweakerMC.getItemStack((IItemStack)input)));
    }

    @ZenMethod
    public static void registerFuelMultiplier(float multiplier, IItemStack input) {
        CraftTweakerActions.apply(new RegisterFuelMultiplierAction(multiplier, CraftTweakerMC.getItemStack((IItemStack)input)));
    }

    @ZenMethod
    public static void deleteItemFuel(IItemStack fuel) {
        CraftTweakerActions.apply(new DeleteItemFuelAction(CraftTweakerMC.getItemStack((IItemStack)fuel)));
    }

    @ZenMethod
    public static void addCanningRecipe(IItemStack output, IIngredient input, IItemStack container) {
        CraftTweakerActions.apply(new AddCanningRecipeAction(CraftTweakerMC.getItemStack((IItemStack)output), IC2RecipeInputs.of(input), CraftTweakerMC.getItemStack((IItemStack)container)));
    }

    public static void removeCanningContainer(IItemStack container) {
        CraftTweakerActions.apply(new RemoveCanningContainerAction(CraftTweakerMC.getItemStack((IItemStack)container)));
    }

    public static void removeCanningRecipe(IItemStack container, IItemStack input) {
        CraftTweakerActions.apply(new RemoveCanningRecipeAction(CraftTweakerMC.getItemStack((IItemStack)container), CraftTweakerMC.getItemStack((IItemStack)input)));
    }

    private static final class DeleteEffectIdAction
    implements IAction {
        private final int id;
        private final boolean items;

        DeleteEffectIdAction(int id, boolean items) {
            this.id = id;
            this.items = items;
        }

        public void apply() {
            ClassicRecipes.canningMachine.deleteEffectID(this.id, this.items);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Remove Food Effect[%s %s] from %s", this.id, this.items, ClassicRecipes.canningMachine);
        }
    }

    private static final class DeleteItemFuelAction
    implements IAction {
        private final ItemStack fuel;

        DeleteItemFuelAction(ItemStack fuel) {
            this.fuel = fuel;
        }

        public void apply() {
            ClassicRecipes.canningMachine.deleteItemFuel(this.fuel);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Add Recipe[%s %s] to %s", this.fuel, ClassicRecipes.canningMachine);
        }
    }

    private static final class RemoveCanningRecipeAction
    implements IAction {
        private final ItemStack input;
        private final ItemStack container;

        RemoveCanningRecipeAction(ItemStack input, ItemStack container) {
            this.input = input;
            this.container = container;
        }

        public void apply() {
            ClassicRecipes.canningMachine.removeCanningRecipe(this.container, this.input);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Remove Recipe[%s %s] from %s", this.input, this.container, ClassicRecipes.canningMachine);
        }
    }

    private static final class RemoveCanningContainerAction
    implements IAction {
        private final ItemStack container;

        RemoveCanningContainerAction(ItemStack container) {
            this.container = container;
        }

        public void apply() {
            ClassicRecipes.canningMachine.removeCanningRecipe(this.container);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Remove Canning Container[%s] from %s", this.container, ClassicRecipes.canningMachine);
        }
    }

    private static final class AddCanningRecipeAction
    implements IAction {
        private final ItemStack output;
        private final IRecipeInput input;
        private final ItemStack container;

        AddCanningRecipeAction(ItemStack output, IRecipeInput input, ItemStack container) {
            this.output = output;
            this.input = input;
            this.container = container;
        }

        public void apply() {
            ClassicRecipes.canningMachine.registerCannerItem(this.container, this.input, this.output);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Add Recipe[%s %s -> %s] to %s", this.input, this.container, this.output, ClassicRecipes.canningMachine);
        }
    }

    private static final class RegisterFuelMultiplierAction
    implements IAction {
        private final float multiplier;
        private final ItemStack input;

        RegisterFuelMultiplierAction(float multiplier, ItemStack input) {
            this.multiplier = multiplier;
            this.input = input;
        }

        public void apply() {
            ClassicRecipes.canningMachine.registerFuelMultiplier(this.input, this.multiplier);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Add Recipe[%s %s] to %s", Float.valueOf(this.multiplier), this.input, ClassicRecipes.canningMachine);
        }
    }

    private static final class RegisterFuelValueAction
    implements IAction {
        private final int value;
        private final ItemStack input;

        RegisterFuelValueAction(int value, ItemStack input) {
            this.value = value;
            this.input = input;
        }

        public void apply() {
            ClassicRecipes.canningMachine.registerFuelValue(this.input, this.value);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Add Recipe[%s %s] to %s", this.value, this.input, ClassicRecipes.canningMachine);
        }
    }

    private static final class RegisterItemsForEffectAction
    implements IAction {
        private final int id;
        private final ItemStack[] input;

        RegisterItemsForEffectAction(int id, ItemStack ... input) {
            this.id = id;
            this.input = input;
        }

        public void apply() {
            ClassicRecipes.canningMachine.registerItemsForEffect(this.id, this.input);
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Add Recipe[%s %s] to %s", this.id, Arrays.deepToString(this.input), ClassicRecipes.canningMachine);
        }
    }
}

