/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2classictweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.api.recipe.IRecipeInput;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import trinsdar.ic2classictweaker.CraftTweakerActions;
import trinsdar.ic2classictweaker.IC2RecipeInputs;

@ModOnly(value="ic2")
@ZenClass(value="mods.ic2.AdvRecipes")
@ZenRegister
public class AdvRecipeSupport {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] input) {
        CraftTweakerActions.apply(new AdvRecipeShapedAction(CraftTweakerMC.getItemStack((IItemStack)output), input, false));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] input) {
        CraftTweakerActions.apply(new AdvRecipeShapelessAction(CraftTweakerMC.getItemStack((IItemStack)output), IC2RecipeInputs.of(input), false));
    }

    @ZenMethod
    public static void addHiddenShaped(IItemStack output, IIngredient[][] input) {
        CraftTweakerActions.apply(new AdvRecipeShapedAction(CraftTweakerMC.getItemStack((IItemStack)output), input, true));
    }

    @ZenMethod
    public static void addHiddenShapeless(IItemStack output, IIngredient[] input) {
        CraftTweakerActions.apply(new AdvRecipeShapelessAction(CraftTweakerMC.getItemStack((IItemStack)output), IC2RecipeInputs.of(input), true));
    }

    private static final class AdvRecipeShapedAction
    implements IAction {
        ItemStack output;
        IIngredient[][] input;
        boolean hidden;

        AdvRecipeShapedAction(ItemStack output, IIngredient[][] input, boolean hidden) {
            this.output = output;
            this.input = input;
            this.hidden = hidden;
        }

        public void apply() {
            ICraftingRecipeList recipes = ClassicRecipes.advCrafting;
            int height = this.input.length;
            if (height > 3) {
                CraftTweakerActions.printError("Outer Recipe Array can only have a max of 3 inner arrays!");
            }
            if (height == 1) {
                int width = this.input[0].length;
                if (width > 3) {
                    CraftTweakerActions.printError("Inner Recipe Array can only have a max of 3 inputs!");
                }
                if (width == 1) {
                    if (this.input[0][0] != null) {
                        recipes.addRecipe(this.output, new Object[]{"A", Character.valueOf('A'), IC2RecipeInputs.of(this.input[0][0]), this.hidden});
                    } else {
                        CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                    }
                } else if (width == 2) {
                    IRecipeInput in01;
                    IRecipeInput in00 = this.input[0][0] != null ? IC2RecipeInputs.of(this.input[0][0]) : null;
                    IRecipeInput iRecipeInput = in01 = this.input[0][1] != null ? IC2RecipeInputs.of(this.input[0][1]) : null;
                    if (in00 == null && in01 == null) {
                        CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                    } else {
                        recipes.addRecipe(this.output, new Object[]{"AB", Character.valueOf('A'), in00, Character.valueOf('B'), in01, this.hidden});
                    }
                } else if (width == 3) {
                    IRecipeInput in02;
                    IRecipeInput in00 = this.input[0][0] != null ? IC2RecipeInputs.of(this.input[0][0]) : null;
                    IRecipeInput in01 = this.input[0][1] != null ? IC2RecipeInputs.of(this.input[0][1]) : null;
                    IRecipeInput iRecipeInput = in02 = this.input[0][2] != null ? IC2RecipeInputs.of(this.input[0][1]) : null;
                    if (in00 == null && in01 == null && in02 == null) {
                        CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                    } else {
                        recipes.addRecipe(this.output, new Object[]{"ABC", Character.valueOf('A'), in00, Character.valueOf('B'), in01, Character.valueOf('C'), in02, this.hidden});
                    }
                }
            } else if (height == 2) {
                int width = this.input[0].length;
                int width2 = this.input[1].length;
                if (width != width2) {
                    CraftTweakerActions.printError("Inner Recipe Arrays must all be the same lengths!");
                }
                if (width > 3 || width2 > 3) {
                    CraftTweakerActions.printError("Inner Recipe Array can only have a max of 3 inputs!");
                }
                if (width == 1) {
                    IRecipeInput in10;
                    IRecipeInput in00 = this.input[0][0] != null ? IC2RecipeInputs.of(this.input[0][0]) : null;
                    IRecipeInput iRecipeInput = in10 = this.input[1][0] != null ? IC2RecipeInputs.of(this.input[1][0]) : null;
                    if (in00 == null && in10 == null) {
                        CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                    } else {
                        recipes.addRecipe(this.output, new Object[]{"A", "B", Character.valueOf('A'), in00, Character.valueOf('B'), in10, this.hidden});
                    }
                } else if (width == 2) {
                    IRecipeInput in11;
                    IRecipeInput in00 = this.input[0][0] != null ? IC2RecipeInputs.of(this.input[0][0]) : null;
                    IRecipeInput in10 = this.input[1][0] != null ? IC2RecipeInputs.of(this.input[1][0]) : null;
                    IRecipeInput in01 = this.input[0][1] != null ? IC2RecipeInputs.of(this.input[0][1]) : null;
                    IRecipeInput iRecipeInput = in11 = this.input[1][1] != null ? IC2RecipeInputs.of(this.input[1][1]) : null;
                    if (in00 == null && in10 == null && in01 == null && in11 == null) {
                        CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                    } else {
                        recipes.addRecipe(this.output, new Object[]{"AB", "CD", Character.valueOf('A'), in00, Character.valueOf('B'), in01, Character.valueOf('C'), in10, Character.valueOf('D'), in11, this.hidden});
                    }
                } else if (width == 3) {
                    IRecipeInput in12;
                    IRecipeInput in00 = this.input[0][0] != null ? IC2RecipeInputs.of(this.input[0][0]) : null;
                    IRecipeInput in10 = this.input[1][0] != null ? IC2RecipeInputs.of(this.input[1][0]) : null;
                    IRecipeInput in01 = this.input[0][1] != null ? IC2RecipeInputs.of(this.input[0][1]) : null;
                    IRecipeInput in11 = this.input[1][1] != null ? IC2RecipeInputs.of(this.input[1][1]) : null;
                    IRecipeInput in02 = this.input[0][2] != null ? IC2RecipeInputs.of(this.input[0][2]) : null;
                    IRecipeInput iRecipeInput = in12 = this.input[1][2] != null ? IC2RecipeInputs.of(this.input[1][2]) : null;
                    if (in00 == null && in10 == null && in01 == null && in11 == null && in02 == null && in12 == null) {
                        CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                    } else {
                        recipes.addRecipe(this.output, new Object[]{"ABC", "DEF", Character.valueOf('A'), in00, Character.valueOf('B'), in01, Character.valueOf('C'), in02, Character.valueOf('D'), in10, Character.valueOf('E'), in11, Character.valueOf('F'), in12, this.hidden});
                    }
                }
            } else if (height == 3) {
                int width = this.input[0].length;
                int width2 = this.input[1].length;
                int width3 = this.input[2].length;
                if (width > 3 || width2 > 3 || width3 > 3) {
                    CraftTweakerActions.printError("Inner Recipe Array can only have a max of 3 inputs!");
                }
                if (width == width2 && width == width3) {
                    if (width == 1) {
                        IRecipeInput in20;
                        IRecipeInput in00 = this.input[0][0] != null ? IC2RecipeInputs.of(this.input[0][0]) : null;
                        IRecipeInput in10 = this.input[1][0] != null ? IC2RecipeInputs.of(this.input[1][0]) : null;
                        IRecipeInput iRecipeInput = in20 = this.input[2][0] != null ? IC2RecipeInputs.of(this.input[2][0]) : null;
                        if (in00 == null && in10 == null && in20 == null) {
                            CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                        } else {
                            recipes.addRecipe(this.output, new Object[]{"A", "B", "C", Character.valueOf('A'), in00, Character.valueOf('B'), in10, Character.valueOf('C'), in20, this.hidden});
                        }
                    } else if (width == 2) {
                        IRecipeInput in21;
                        IRecipeInput in00 = this.input[0][0] != null ? IC2RecipeInputs.of(this.input[0][0]) : null;
                        IRecipeInput in10 = this.input[1][0] != null ? IC2RecipeInputs.of(this.input[1][0]) : null;
                        IRecipeInput in20 = this.input[2][0] != null ? IC2RecipeInputs.of(this.input[2][0]) : null;
                        IRecipeInput in01 = this.input[0][1] != null ? IC2RecipeInputs.of(this.input[0][1]) : null;
                        IRecipeInput in11 = this.input[1][1] != null ? IC2RecipeInputs.of(this.input[1][1]) : null;
                        IRecipeInput iRecipeInput = in21 = this.input[2][1] != null ? IC2RecipeInputs.of(this.input[2][1]) : null;
                        if (in00 == null && in10 == null && in20 == null && in01 == null && in11 == null && in21 == null) {
                            CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                        } else {
                            recipes.addRecipe(this.output, new Object[]{"AB", "CD", "EF", Character.valueOf('A'), in00, Character.valueOf('B'), in01, Character.valueOf('C'), in10, Character.valueOf('D'), in11, Character.valueOf('E'), in20, Character.valueOf('F'), in21, this.hidden});
                        }
                    } else if (width == 3) {
                        IRecipeInput in22;
                        IRecipeInput in00 = this.input[0][0] != null ? IC2RecipeInputs.of(this.input[0][0]) : null;
                        IRecipeInput in10 = this.input[1][0] != null ? IC2RecipeInputs.of(this.input[1][0]) : null;
                        IRecipeInput in20 = this.input[2][0] != null ? IC2RecipeInputs.of(this.input[2][0]) : null;
                        IRecipeInput in01 = this.input[0][1] != null ? IC2RecipeInputs.of(this.input[0][1]) : null;
                        IRecipeInput in11 = this.input[1][1] != null ? IC2RecipeInputs.of(this.input[1][1]) : null;
                        IRecipeInput in21 = this.input[2][1] != null ? IC2RecipeInputs.of(this.input[2][1]) : null;
                        IRecipeInput in02 = this.input[0][2] != null ? IC2RecipeInputs.of(this.input[0][2]) : null;
                        IRecipeInput in12 = this.input[1][2] != null ? IC2RecipeInputs.of(this.input[1][2]) : null;
                        IRecipeInput iRecipeInput = in22 = this.input[2][2] != null ? IC2RecipeInputs.of(this.input[2][2]) : null;
                        if (in00 == null && in10 == null && in20 == null && in01 == null && in11 == null && in21 == null && in02 == null && in12 == null && in22 == null) {
                            CraftTweakerActions.printError("Recipe must have at least one nonnull input!");
                        } else {
                            recipes.addRecipe(this.output, new Object[]{"ABC", "DEF", "GHI", Character.valueOf('A'), in00, Character.valueOf('B'), in01, Character.valueOf('C'), in02, Character.valueOf('D'), in10, Character.valueOf('E'), in11, Character.valueOf('F'), in12, Character.valueOf('G'), in20, Character.valueOf('H'), in21, Character.valueOf('I'), in22, this.hidden});
                        }
                    }
                } else {
                    CraftTweakerActions.printError("Inner Recipe Arrays must all be the same lengths!");
                }
            }
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Add Stacked Shaped Crafting Recipe[%s -> %s] to %s", Arrays.deepToString((Object[])this.input), this.output, ClassicRecipes.advCrafting);
        }
    }

    private static final class AdvRecipeShapelessAction
    implements IAction {
        ItemStack output;
        IRecipeInput[] inputs;
        boolean hidden;

        AdvRecipeShapelessAction(ItemStack output, IRecipeInput[] inputs, boolean hidden) {
            this.output = output;
            this.inputs = inputs;
            this.hidden = hidden;
        }

        public void apply() {
            ClassicRecipes.advCrafting.addShapelessRecipe(this.output, new Object[]{this.inputs, this.hidden});
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Add Stacked Shapeless Crafting Recipe[%s -> %s] to %s", Arrays.deepToString(this.inputs), this.output, ClassicRecipes.advCrafting);
        }
    }
}

