/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class MaxHealthHandler {
    private static final UUID MILESTONE_HEALTH_MODIFIER_ID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        MaxHealthHandler.updateFoodHPModifier(player);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        AttributeModifier prevModifier = MaxHealthHandler.getHealthModifier(event.getOriginal());
        if (prevModifier == null) {
            return;
        }
        MaxHealthHandler.updateHealthModifier(event.getEntityPlayer(), prevModifier);
    }

    public static boolean updateFoodHPModifier(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        AttributeModifier prevModifier = MaxHealthHandler.getHealthModifier(player);
        int healthPenalty = 2 * (SOLCarrotConfig.baseHearts - 10);
        ProgressInfo progressInfo = FoodList.get(player).getProgressInfo();
        int milestonesAchieved = progressInfo.milestonesAchieved();
        int addedHealthFromFood = milestonesAchieved * 2 * SOLCarrotConfig.heartsPerMilestone;
        double totalHealthModifier = healthPenalty + addedHealthFromFood;
        if (prevModifier == null || prevModifier.func_111164_d() != totalHealthModifier) {
            AttributeModifier modifier = new AttributeModifier(MILESTONE_HEALTH_MODIFIER_ID, "Health Gained from Trying New Foods", totalHealthModifier, 0);
            float oldMax = player.func_110138_aP();
            MaxHealthHandler.updateHealthModifier(player, modifier);
            player.func_70606_j(player.func_110143_aJ() * player.func_110138_aP() / oldMax);
            return true;
        }
        return false;
    }

    @Nullable
    private static AttributeModifier getHealthModifier(EntityPlayer player) {
        return MaxHealthHandler.maxHealthAttribute(player).func_111127_a(MILESTONE_HEALTH_MODIFIER_ID);
    }

    private static void updateHealthModifier(EntityPlayer player, AttributeModifier modifier) {
        IAttributeInstance attribute = MaxHealthHandler.maxHealthAttribute(player);
        attribute.func_111124_b(modifier);
        attribute.func_111121_a(modifier);
    }

    private static IAttributeInstance maxHealthAttribute(EntityPlayer player) {
        return player.func_110148_a(SharedMonsterAttributes.field_111267_a);
    }

    private MaxHealthHandler() {
    }
}

