/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.binarypatcher;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import joptsimple.internal.Strings;
import lzma.streams.LzmaOutputStream;
import net.minecraftforge.binarypatcher.ConsoleTool;
import net.minecraftforge.binarypatcher.Patch;
import org.apache.commons.io.IOUtils;

public class Generator {
    public static final String EXTENSION = ".lzma";
    private static final byte[] EMPTY_DATA = new byte[0];
    private final BiMap<String, String> classes = HashBiMap.create();
    private final Set<String> patches = new TreeSet<String>();
    private final File clean;
    private final File dirty;
    private final File output;

    public Generator(File clean, File dirty, File output) {
        this.clean = clean;
        this.dirty = dirty;
        this.output = output;
    }

    public void loadMappings(File srg) throws IOException {
        List lines = com.google.common.io.Files.readLines((File)srg, (Charset)StandardCharsets.UTF_8).stream().map(line -> line.split("#")[0]).filter(l -> !Strings.isNullOrEmpty((String)l.trim())).collect(Collectors.toList());
        lines.stream().filter(line -> !line.startsWith("\t") || line.indexOf(58) != -1 && line.startsWith("CL:")).map(line -> line.indexOf(58) != -1 ? line.substring(4).split(" ") : line.split(" ")).filter(pts -> ((String[])pts).length == 2 && !pts[0].endsWith("/")).forEach(pts -> {
            String cfr_ignored_0 = (String)this.classes.put((Object)pts[0], (Object)pts[1]);
        });
    }

    public void loadPatches(File root) throws IOException {
        int base = root.getAbsolutePath().length();
        int suffix = ".java.patch".length();
        Files.walk(root.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> p.toAbsolutePath().toString()).filter(p -> p.endsWith(".java.patch")).forEach(path -> {
            String relative = path.substring(base + 1).replace('\\', '/');
            this.patches.add(relative.substring(0, relative.length() - suffix));
        });
    }

    public void create() throws IOException {
        TreeMap<String, byte[]> binpatches;
        block42: {
            binpatches = new TreeMap<String, byte[]>();
            try (ZipFile zclean = new ZipFile(this.clean);
                 ZipFile zdirty = new ZipFile(this.dirty);){
                this.log("Gathering class names");
                HashMap entries = new HashMap();
                Collections.list(zclean.entries()).stream().map(e -> e.getName()).filter(e -> e.endsWith(".class")).map(e -> e.substring(0, e.length() - 6)).forEach(e -> {
                    int idx = e.indexOf(36);
                    if (idx != -1) {
                        entries.computeIfAbsent(e.substring(0, idx), k -> new HashSet()).add(e);
                    } else {
                        entries.computeIfAbsent(e, k -> new HashSet()).add(e);
                    }
                });
                Collections.list(zdirty.entries()).stream().map(e -> e.getName()).filter(e -> e.endsWith(".class")).map(e -> e.substring(0, e.length() - 6)).forEach(e -> {
                    int idx = e.indexOf(36);
                    if (idx != -1) {
                        entries.computeIfAbsent(e.substring(0, idx), k -> new HashSet()).add(e);
                    } else {
                        entries.computeIfAbsent(e, k -> new HashSet()).add(e);
                    }
                });
                this.log("Creating patches");
                if (this.patches.isEmpty()) {
                    for (String cls : entries.keySet()) {
                        byte[] dirty;
                        String srg = (String)this.classes.inverse().getOrDefault((Object)cls, (Object)cls);
                        byte[] clean = this.getData(zclean, cls);
                        if (Arrays.equals(clean, dirty = this.getData(zdirty, cls))) continue;
                        byte[] patch = this.process(cls, srg, clean, dirty);
                        binpatches.put(srg.replace('/', '.') + ".binpatch", patch);
                    }
                    break block42;
                }
                for (String path : this.patches) {
                    String obf = (String)this.classes.getOrDefault((Object)path, (Object)path);
                    if (entries.containsKey(obf)) {
                        for (String cls : (Set)entries.get(obf)) {
                            byte[] dirty;
                            byte[] clean;
                            String srg = (String)this.classes.inverse().get((Object)cls);
                            if (srg == null) {
                                int idx = cls.indexOf(36);
                                srg = path + '$' + cls.substring(idx + 1);
                            }
                            if (Arrays.equals(clean = this.getData(zclean, cls), dirty = this.getData(zdirty, cls))) continue;
                            byte[] patch = this.process(cls, srg, clean, dirty);
                            binpatches.put(srg.replace('/', '.') + ".binpatch", patch);
                        }
                        continue;
                    }
                    this.log("Failed: no source for patch? " + path + " " + obf);
                }
            }
        }
        byte[] data = this.createJar(binpatches);
        data = this.lzma(data);
        try (FileOutputStream fos = new FileOutputStream(this.output);){
            IOUtils.write((byte[])data, (OutputStream)fos);
        }
    }

    private byte[] getData(ZipFile zip, String cls) throws IOException {
        ZipEntry entry = zip.getEntry(cls + ".class");
        return entry == null ? EMPTY_DATA : IOUtils.toByteArray((InputStream)zip.getInputStream(entry));
    }

    private byte[] createJar(Map<String, byte[]> patches) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JarOutputStream zout = new JarOutputStream(out);){
            for (Map.Entry<String, byte[]> e : patches.entrySet()) {
                ZipEntry entry = new ZipEntry(e.getKey());
                entry.setTime(628041600000L);
                zout.putNextEntry(entry);
                zout.write(e.getValue());
                zout.closeEntry();
            }
        }
        return out.toByteArray();
    }

    private byte[] lzma(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (LzmaOutputStream lzma = new LzmaOutputStream.Builder((OutputStream)out).useEndMarkerMode(true).build();){
            lzma.write(data);
        }
        return out.toByteArray();
    }

    private byte[] process(String obf, String srg, byte[] clean, byte[] dirty) throws IOException {
        if (srg.equals(obf)) {
            this.log("Processing " + srg);
        } else {
            this.log("Processing " + srg + "(" + obf + ")");
        }
        Patch patch = Patch.from(obf, srg, clean, dirty);
        this.log("  Clean: " + Integer.toHexString(patch.checksum(clean)) + " Dirty: " + Integer.toHexString(patch.checksum(dirty)));
        return patch.toBytes();
    }

    private void log(String message) {
        ConsoleTool.log(message);
    }
}

