/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.MapBanner;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.MapFrame;
import net.minecraft.world.storage.WorldSavedData;

public class MapData
extends WorldSavedData {
    public int field_76201_a;
    public int field_76199_b;
    public DimensionType field_76200_c;
    public boolean field_186210_e;
    public boolean field_191096_f;
    public byte field_76197_d;
    public byte[] field_76198_e = new byte[16384];
    public boolean field_215161_h;
    public final List<MapInfo> field_76196_g = Lists.newArrayList();
    private final Map<PlayerEntity, MapInfo> field_76202_j = Maps.newHashMap();
    private final Map<String, MapBanner> field_204270_k = Maps.newHashMap();
    public final Map<String, MapDecoration> field_76203_h = Maps.newLinkedHashMap();
    private final Map<String, MapFrame> field_212442_l = Maps.newHashMap();

    public MapData(String string) {
        super(string);
    }

    public void func_212440_a(int n, int n2, int n3, boolean bl, boolean bl2, DimensionType dimensionType) {
        this.field_76197_d = (byte)n3;
        this.func_176054_a(n, n2, this.field_76197_d);
        this.field_76200_c = dimensionType;
        this.field_186210_e = bl;
        this.field_191096_f = bl2;
        this.func_76185_a();
    }

    public void func_176054_a(double d, double d2, int n) {
        \u2603 = 128 * (1 << n);
        \u2603 = MathHelper.func_76128_c((d + 64.0) / (double)\u2603);
        \u2603 = MathHelper.func_76128_c((d2 + 64.0) / (double)\u2603);
        this.field_76201_a = \u2603 * \u2603 + \u2603 / 2 - 64;
        this.field_76199_b = \u2603 * \u2603 + \u2603 / 2 - 64;
    }

    @Override
    public void func_76184_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        int n = compoundNBT2.func_74762_e("dimension");
        DimensionType \u26032 = DimensionType.func_186069_a(n);
        if (\u26032 == null) {
            throw new IllegalArgumentException("Invalid map dimension: " + n);
        }
        this.field_76200_c = \u26032;
        this.field_76201_a = compoundNBT2.func_74762_e("xCenter");
        this.field_76199_b = compoundNBT2.func_74762_e("zCenter");
        this.field_76197_d = (byte)MathHelper.func_76125_a(compoundNBT2.func_74771_c("scale"), 0, 4);
        this.field_186210_e = !compoundNBT2.func_150297_b("trackingPosition", 1) || compoundNBT2.func_74767_n("trackingPosition");
        this.field_191096_f = compoundNBT2.func_74767_n("unlimitedTracking");
        this.field_215161_h = compoundNBT2.func_74767_n("locked");
        this.field_76198_e = compoundNBT2.func_74770_j("colors");
        if (this.field_76198_e.length != 16384) {
            this.field_76198_e = new byte[16384];
        }
        ListNBT \u26033 = compoundNBT2.func_150295_c("banners", 10);
        for (\u2603 = 0; \u2603 < \u26033.size(); ++\u2603) {
            MapBanner mapBanner = MapBanner.func_204300_a(\u26033.func_150305_b(\u2603));
            this.field_204270_k.put(mapBanner.func_204299_f(), mapBanner);
            this.func_191095_a(mapBanner.func_204305_c(), null, mapBanner.func_204299_f(), mapBanner.func_204304_a().func_177958_n(), mapBanner.func_204304_a().func_177952_p(), 180.0, mapBanner.func_204302_d());
        }
        ListNBT \u26034 = compoundNBT2.func_150295_c("frames", 10);
        for (int i = 0; i < \u26034.size(); ++i) {
            MapFrame mapFrame = MapFrame.func_212765_a(\u26034.func_150305_b(i));
            this.field_212442_l.put(mapFrame.func_212767_e(), mapFrame);
            this.func_191095_a(MapDecoration.Type.FRAME, null, "frame-" + mapFrame.func_212769_d(), mapFrame.func_212764_b().func_177958_n(), mapFrame.func_212764_b().func_177952_p(), mapFrame.func_212768_c(), null);
        }
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        compoundNBT2.func_74768_a("dimension", this.field_76200_c.func_186068_a());
        compoundNBT2.func_74768_a("xCenter", this.field_76201_a);
        compoundNBT2.func_74768_a("zCenter", this.field_76199_b);
        compoundNBT2.func_74774_a("scale", this.field_76197_d);
        compoundNBT2.func_74773_a("colors", this.field_76198_e);
        compoundNBT2.func_74757_a("trackingPosition", this.field_186210_e);
        compoundNBT2.func_74757_a("unlimitedTracking", this.field_191096_f);
        compoundNBT2.func_74757_a("locked", this.field_215161_h);
        ListNBT listNBT = new ListNBT();
        for (MapBanner mapBanner : this.field_204270_k.values()) {
            listNBT.add(mapBanner.func_204303_e());
        }
        compoundNBT2.func_218657_a("banners", listNBT);
        ListNBT \u26032 = new ListNBT();
        for (MapFrame mapFrame : this.field_212442_l.values()) {
            \u26032.add(mapFrame.func_212770_a());
        }
        compoundNBT2.func_218657_a("frames", \u26032);
        return compoundNBT2;
    }

    public void func_215160_a(MapData mapData) {
        this.field_215161_h = true;
        this.field_76201_a = mapData.field_76201_a;
        this.field_76199_b = mapData.field_76199_b;
        this.field_204270_k.putAll(mapData.field_204270_k);
        this.field_76203_h.putAll(mapData.field_76203_h);
        System.arraycopy(mapData.field_76198_e, 0, this.field_76198_e, 0, mapData.field_76198_e.length);
        this.func_76185_a();
    }

    public void func_76191_a(PlayerEntity playerEntity2, ItemStack itemStack2) {
        Object \u26034;
        ItemStack itemStack2;
        Object \u26032;
        PlayerEntity playerEntity2;
        if (!this.field_76202_j.containsKey(playerEntity2)) {
            MapInfo mapInfo = new MapInfo(playerEntity2);
            this.field_76202_j.put(playerEntity2, mapInfo);
            this.field_76196_g.add(mapInfo);
        }
        if (!playerEntity2.field_71071_by.func_70431_c(itemStack2)) {
            this.field_76203_h.remove(playerEntity2.func_200200_C_().getString());
        }
        for (int i = 0; i < this.field_76196_g.size(); ++i) {
            \u26032 = this.field_76196_g.get(i);
            \u26033 = ((MapInfo)\u26032).field_76211_a.func_200200_C_().getString();
            if (((MapInfo)\u26032).field_76211_a.field_70128_L || !((MapInfo)\u26032).field_76211_a.field_71071_by.func_70431_c(itemStack2) && !itemStack2.func_82839_y()) {
                this.field_76202_j.remove(((MapInfo)\u26032).field_76211_a);
                this.field_76196_g.remove(\u26032);
                this.field_76203_h.remove(\u26033);
                continue;
            }
            if (itemStack2.func_82839_y() || ((MapInfo)\u26032).field_76211_a.field_71093_bK != this.field_76200_c || !this.field_186210_e) continue;
            this.func_191095_a(MapDecoration.Type.PLAYER, ((MapInfo)\u26032).field_76211_a.field_70170_p, (String)\u26033, ((MapInfo)\u26032).field_76211_a.field_70165_t, ((MapInfo)\u26032).field_76211_a.field_70161_v, ((MapInfo)\u26032).field_76211_a.field_70177_z, null);
        }
        if (itemStack2.func_82839_y() && this.field_186210_e) {
            ItemFrameEntity itemFrameEntity = itemStack2.func_82836_z();
            \u26032 = itemFrameEntity.func_174857_n();
            Object \u26033 = this.field_212442_l.get(MapFrame.func_212766_a((BlockPos)\u26032));
            if (\u26033 != null && itemFrameEntity.func_145782_y() != ((MapFrame)\u26033).func_212769_d() && this.field_212442_l.containsKey(((MapFrame)\u26033).func_212767_e())) {
                this.field_76203_h.remove("frame-" + ((MapFrame)\u26033).func_212769_d());
            }
            \u26034 = new MapFrame((BlockPos)\u26032, itemFrameEntity.func_174811_aO().func_176736_b() * 90, itemFrameEntity.func_145782_y());
            this.func_191095_a(MapDecoration.Type.FRAME, playerEntity2.field_70170_p, "frame-" + itemFrameEntity.func_145782_y(), ((Vec3i)\u26032).func_177958_n(), ((Vec3i)\u26032).func_177952_p(), itemFrameEntity.func_174811_aO().func_176736_b() * 90, null);
            this.field_212442_l.put(((MapFrame)\u26034).func_212767_e(), (MapFrame)\u26034);
        }
        if ((\u2603 = itemStack2.func_77978_p()) != null && \u2603.func_150297_b("Decorations", 9)) {
            \u26032 = \u2603.func_150295_c("Decorations", 10);
            for (int i = 0; i < ((ListNBT)\u26032).size(); ++i) {
                \u26034 = ((ListNBT)\u26032).func_150305_b(i);
                if (this.field_76203_h.containsKey(((CompoundNBT)\u26034).func_74779_i("id"))) continue;
                this.func_191095_a(MapDecoration.Type.func_191159_a(((CompoundNBT)\u26034).func_74771_c("type")), playerEntity2.field_70170_p, ((CompoundNBT)\u26034).func_74779_i("id"), ((CompoundNBT)\u26034).func_74769_h("x"), ((CompoundNBT)\u26034).func_74769_h("z"), ((CompoundNBT)\u26034).func_74769_h("rot"), null);
            }
        }
    }

    public static void func_191094_a(ItemStack itemStack, BlockPos blockPos, String string, MapDecoration.Type type) {
        ListNBT listNBT;
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("Decorations", 9)) {
            listNBT = itemStack.func_77978_p().func_150295_c("Decorations", 10);
        } else {
            listNBT = new ListNBT();
            itemStack.func_77983_a("Decorations", listNBT);
        }
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74774_a("type", type.func_191163_a());
        compoundNBT.func_74778_a("id", string);
        compoundNBT.func_74780_a("x", blockPos.func_177958_n());
        compoundNBT.func_74780_a("z", blockPos.func_177952_p());
        compoundNBT.func_74780_a("rot", 180.0);
        listNBT.add(compoundNBT);
        if (type.func_191162_c()) {
            \u2603 = itemStack.func_190925_c("display");
            \u2603.func_74768_a("MapColor", type.func_191161_d());
        }
    }

    private void func_191095_a(MapDecoration.Type \u260372, @Nullable IWorld iWorld, String string2, double d, double d2, double d3, @Nullable ITextComponent iTextComponent) {
        String string2;
        MapDecoration.Type \u260372;
        byte \u26036;
        int n = 1 << this.field_76197_d;
        float \u26032 = (float)(d - (double)this.field_76201_a) / (float)n;
        float \u26033 = (float)(d2 - (double)this.field_76199_b) / (float)n;
        byte \u26034 = (byte)((double)(\u26032 * 2.0f) + 0.5);
        byte \u26035 = (byte)((double)(\u26033 * 2.0f) + 0.5);
        \u2603 = 63;
        if (\u26032 >= -63.0f && \u26033 >= -63.0f && \u26032 <= 63.0f && \u26033 <= 63.0f) {
            \u26036 = (byte)((d3 += d3 < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.field_76200_c == DimensionType.field_223228_b_ && iWorld != null) {
                int n2 = (int)(iWorld.func_72912_H().func_76073_f() / 10L);
                \u26036 = (byte)(n2 * n2 * 34187121 + n2 * 121 >> 15 & 0xF);
            }
        } else if (\u260372 == MapDecoration.Type.PLAYER) {
            \u2603 = 320;
            if (Math.abs(\u26032) < 320.0f && Math.abs(\u26033) < 320.0f) {
                \u260372 = MapDecoration.Type.PLAYER_OFF_MAP;
            } else if (this.field_191096_f) {
                \u260372 = MapDecoration.Type.PLAYER_OFF_LIMITS;
            } else {
                this.field_76203_h.remove(string2);
                return;
            }
            \u26036 = 0;
            if (\u26032 <= -63.0f) {
                \u26034 = -128;
            }
            if (\u26033 <= -63.0f) {
                \u26035 = -128;
            }
            if (\u26032 >= 63.0f) {
                \u26034 = 127;
            }
            if (\u26033 >= 63.0f) {
                \u26035 = 127;
            }
        } else {
            this.field_76203_h.remove(string2);
            return;
        }
        this.field_76203_h.put(string2, new MapDecoration(\u260372, \u26034, \u26035, \u26036, iTextComponent));
    }

    @Nullable
    public IPacket<?> func_176052_a(ItemStack itemStack, IBlockReader iBlockReader, PlayerEntity playerEntity) {
        MapInfo mapInfo = this.field_76202_j.get(playerEntity);
        if (mapInfo == null) {
            return null;
        }
        return mapInfo.func_176101_a(itemStack);
    }

    public void func_176053_a(int n, int n2) {
        this.func_76185_a();
        for (MapInfo mapInfo : this.field_76196_g) {
            mapInfo.func_176102_a(n, n2);
        }
    }

    public MapInfo func_82568_a(PlayerEntity playerEntity) {
        MapInfo mapInfo = this.field_76202_j.get(playerEntity);
        if (mapInfo == null) {
            mapInfo = new MapInfo(playerEntity);
            this.field_76202_j.put(playerEntity, mapInfo);
            this.field_76196_g.add(mapInfo);
        }
        return mapInfo;
    }

    public void func_204269_a(IWorld iWorld, BlockPos blockPos) {
        float f = (float)blockPos.func_177958_n() + 0.5f;
        \u2603 = (float)blockPos.func_177952_p() + 0.5f;
        int \u26032 = 1 << this.field_76197_d;
        \u2603 = (f - (float)this.field_76201_a) / (float)\u26032;
        \u2603 = (\u2603 - (float)this.field_76199_b) / (float)\u26032;
        int \u26033 = 63;
        boolean \u26034 = false;
        if (\u2603 >= -63.0f && \u2603 >= -63.0f && \u2603 <= 63.0f && \u2603 <= 63.0f) {
            MapBanner mapBanner = MapBanner.func_204301_a(iWorld, blockPos);
            if (mapBanner == null) {
                return;
            }
            boolean \u26035 = true;
            if (this.field_204270_k.containsKey(mapBanner.func_204299_f()) && this.field_204270_k.get(mapBanner.func_204299_f()).equals(mapBanner)) {
                this.field_204270_k.remove(mapBanner.func_204299_f());
                this.field_76203_h.remove(mapBanner.func_204299_f());
                \u26035 = false;
                \u26034 = true;
            }
            if (\u26035) {
                this.field_204270_k.put(mapBanner.func_204299_f(), mapBanner);
                this.func_191095_a(mapBanner.func_204305_c(), iWorld, mapBanner.func_204299_f(), f, \u2603, 180.0, mapBanner.func_204302_d());
                \u26034 = true;
            }
            if (\u26034) {
                this.func_76185_a();
            }
        }
    }

    public void func_204268_a(IBlockReader iBlockReader, int n, int n2) {
        Iterator<MapBanner> iterator = this.field_204270_k.values().iterator();
        while (iterator.hasNext()) {
            MapBanner mapBanner = iterator.next();
            if (mapBanner.func_204304_a().func_177958_n() != n || mapBanner.func_204304_a().func_177952_p() != n2 || mapBanner.equals(\u2603 = MapBanner.func_204301_a(iBlockReader, mapBanner.func_204304_a()))) continue;
            iterator.remove();
            this.field_76203_h.remove(mapBanner.func_204299_f());
        }
    }

    public void func_212441_a(BlockPos blockPos, int n) {
        this.field_76203_h.remove("frame-" + n);
        this.field_212442_l.remove(MapFrame.func_212766_a(blockPos));
    }

    public class MapInfo {
        public final PlayerEntity field_76211_a;
        private boolean field_176105_d = true;
        private int field_176106_e;
        private int field_176103_f;
        private int field_176104_g = 127;
        private int field_176108_h = 127;
        private int field_176109_i;
        public int field_82569_d;

        public MapInfo(PlayerEntity playerEntity) {
            this.field_76211_a = playerEntity;
        }

        @Nullable
        public IPacket<?> func_176101_a(ItemStack itemStack) {
            if (this.field_176105_d) {
                this.field_176105_d = false;
                return new SMapDataPacket(FilledMapItem.func_195949_f(itemStack), MapData.this.field_76197_d, MapData.this.field_186210_e, MapData.this.field_215161_h, MapData.this.field_76203_h.values(), MapData.this.field_76198_e, this.field_176106_e, this.field_176103_f, this.field_176104_g + 1 - this.field_176106_e, this.field_176108_h + 1 - this.field_176103_f);
            }
            if (this.field_176109_i++ % 5 == 0) {
                return new SMapDataPacket(FilledMapItem.func_195949_f(itemStack), MapData.this.field_76197_d, MapData.this.field_186210_e, MapData.this.field_215161_h, MapData.this.field_76203_h.values(), MapData.this.field_76198_e, 0, 0, 0, 0);
            }
            return null;
        }

        public void func_176102_a(int n, int n2) {
            if (this.field_176105_d) {
                this.field_176106_e = Math.min(this.field_176106_e, n);
                this.field_176103_f = Math.min(this.field_176103_f, n2);
                this.field_176104_g = Math.max(this.field_176104_g, n);
                this.field_176108_h = Math.max(this.field_176108_h, n2);
            } else {
                this.field_176105_d = true;
                this.field_176106_e = n;
                this.field_176103_f = n2;
                this.field_176104_g = n;
                this.field_176108_h = n2;
            }
        }
    }
}

