/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;

public interface IWorldReader
extends IEnviromentBlockReader {
    default public boolean func_175623_d(BlockPos blockPos) {
        return this.func_180495_p(blockPos).func_196958_f();
    }

    default public boolean func_175710_j(BlockPos blockPos) {
        if (blockPos.func_177956_o() >= this.func_181545_F()) {
            return this.func_217337_f(blockPos);
        }
        \u26032 = new BlockPos(blockPos.func_177958_n(), this.func_181545_F(), blockPos.func_177952_p());
        if (!this.func_217337_f(\u26032)) {
            return false;
        }
        \u26032 = \u26032.func_177977_b();
        while (\u26032.func_177956_o() > blockPos.func_177956_o()) {
            BlockState blockState = this.func_180495_p(\u26032);
            if (blockState.func_200016_a(this, \u26032) > 0 && !blockState.func_185904_a().func_76224_d()) {
                return false;
            }
            BlockPos \u26032 = \u26032.func_177977_b();
        }
        return true;
    }

    public int func_201669_a(BlockPos var1, int var2);

    @Nullable
    public IChunk func_217353_a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean func_217354_b(int var1, int var2);

    public BlockPos func_205770_a(Heightmap.Type var1, BlockPos var2);

    public int func_201676_a(Heightmap.Type var1, int var2, int var3);

    default public float func_205052_D(BlockPos blockPos) {
        return this.func_201675_m().func_177497_p()[this.func_201696_r(blockPos)];
    }

    public int func_175657_ab();

    public WorldBorder func_175723_af();

    public boolean func_195585_a(@Nullable Entity var1, VoxelShape var2);

    default public int func_175627_a(BlockPos blockPos, Direction direction) {
        return this.func_180495_p(blockPos).func_185893_b(this, blockPos, direction);
    }

    public boolean func_201670_d();

    public int func_181545_F();

    default public IChunk func_217349_x(BlockPos blockPos) {
        return this.func_212866_a_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    default public IChunk func_212866_a_(int n, int n2) {
        return this.func_217353_a(n, n2, ChunkStatus.field_222617_m, true);
    }

    default public IChunk func_217348_a(int n, int n2, ChunkStatus chunkStatus) {
        return this.func_217353_a(n, n2, chunkStatus, true);
    }

    default public ChunkStatus func_217342_O() {
        return ChunkStatus.field_223226_a_;
    }

    default public boolean func_217350_a(BlockState blockState, BlockPos blockPos, ISelectionContext iSelectionContext) {
        VoxelShape voxelShape = blockState.func_215685_b(this, blockPos, iSelectionContext);
        return voxelShape.func_197766_b() || this.func_195585_a(null, voxelShape.func_197751_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
    }

    default public boolean func_217346_i(Entity entity) {
        return this.func_195585_a(entity, VoxelShapes.func_197881_a(entity.func_174813_aQ()));
    }

    default public boolean func_217351_c(AxisAlignedBB axisAlignedBB) {
        return this.func_211156_a(null, axisAlignedBB, Collections.emptySet());
    }

    default public boolean func_217345_j(Entity entity) {
        return this.func_211156_a(entity, entity.func_174813_aQ(), Collections.emptySet());
    }

    default public boolean func_195586_b(Entity entity, AxisAlignedBB axisAlignedBB) {
        return this.func_211156_a(entity, axisAlignedBB, Collections.emptySet());
    }

    default public boolean func_211156_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> set) {
        return this.func_217352_b(entity, axisAlignedBB, set).allMatch(VoxelShape::func_197766_b);
    }

    default public Stream<VoxelShape> func_223439_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> set) {
        return Stream.empty();
    }

    default public Stream<VoxelShape> func_217352_b(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, Set<Entity> set) {
        return Streams.concat((Stream[])new Stream[]{this.func_223438_b(entity, axisAlignedBB), this.func_223439_a(entity, axisAlignedBB, set)});
    }

    default public Stream<VoxelShape> func_223438_b(final @Nullable Entity entity, AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72336_d + 1.0E-7) + 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72337_e + 1.0E-7) + 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72334_f + 1.0E-7) + 1;
        final ISelectionContext \u26032 = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a(entity);
        final CubeCoordinateIterator \u26033 = new CubeCoordinateIterator(n, \u2603, \u2603, \u2603, \u2603, \u2603);
        final BlockPos.MutableBlockPos \u26034 = new BlockPos.MutableBlockPos();
        final VoxelShape \u26035 = VoxelShapes.func_197881_a(axisAlignedBB);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){
            boolean field_223028_a;
            {
                super(l, n);
                this.field_223028_a = entity == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> consumer) {
                int \u260332;
                int \u260322;
                if (!this.field_223028_a) {
                    this.field_223028_a = true;
                    VoxelShape voxelShape = IWorldReader.this.func_175723_af().func_222521_a();
                    \u260322 = VoxelShapes.func_197879_c(voxelShape, VoxelShapes.func_197881_a(entity.func_174813_aQ().func_186664_h(1.0E-7)), IBooleanFunction.field_223238_i_) ? 1 : 0;
                    \u260332 = VoxelShapes.func_197879_c(voxelShape, VoxelShapes.func_197881_a(entity.func_174813_aQ().func_186662_g(1.0E-7)), IBooleanFunction.field_223238_i_) ? 1 : 0;
                    if (\u260322 == 0 && \u260332 != 0) {
                        consumer.accept(voxelShape);
                        return true;
                    }
                }
                while (\u26033.func_218301_a()) {
                    int \u260342 = \u26033.func_218304_b();
                    \u260322 = \u26033.func_218302_c();
                    \u260332 = \u26033.func_218303_d();
                    int \u260352 = \u26033.func_223473_e();
                    if (\u260352 == 3 || (\u2603 = IWorldReader.this.func_217353_a(\u2603 = \u260342 >> 4, \u2603 = \u260332 >> 4, IWorldReader.this.func_217342_O(), false)) == null) continue;
                    \u26034.func_181079_c(\u260342, \u260322, \u260332);
                    BlockState \u26036 = \u2603.func_180495_p(\u26034);
                    if (\u260352 == 1 && !\u26036.func_215704_f() || \u260352 == 2 && \u26036.func_177230_c() != Blocks.field_196603_bb || !VoxelShapes.func_197879_c(\u26035, \u2603 = (\u2603 = \u26036.func_215685_b(IWorldReader.this, \u26034, \u26032)).func_197751_a(\u260342, \u260322, \u260332), IBooleanFunction.field_223238_i_)) continue;
                    consumer.accept(\u2603);
                    return true;
                }
                return false;
            }
        }, false);
    }

    default public boolean func_201671_F(BlockPos blockPos) {
        return this.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
    }

    default public boolean func_72953_d(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        try (BlockPos.PooledMutableBlockPos \u26032 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        BlockState blockState = this.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603));
                        if (blockState.func_204520_s().func_206888_e()) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    default public int func_201696_r(BlockPos blockPos) {
        return this.func_205049_d(blockPos, this.func_175657_ab());
    }

    default public int func_205049_d(BlockPos blockPos, int n) {
        if (blockPos.func_177958_n() < -30000000 || blockPos.func_177952_p() < -30000000 || blockPos.func_177958_n() >= 30000000 || blockPos.func_177952_p() >= 30000000) {
            return 15;
        }
        return this.func_201669_a(blockPos, n);
    }

    @Deprecated
    default public boolean func_175667_e(BlockPos blockPos) {
        return this.func_217354_b(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    @Deprecated
    default public boolean func_175707_a(BlockPos blockPos, BlockPos blockPos2) {
        return this.func_217344_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos2.func_177958_n(), blockPos2.func_177956_o(), blockPos2.func_177952_p());
    }

    @Deprecated
    default public boolean func_217344_a(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0 || n2 >= 256) {
            return false;
        }
        n3 >>= 4;
        n4 >>= 4;
        n6 >>= 4;
        for (\u2603 = n >>= 4; \u2603 <= n4; ++\u2603) {
            for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                if (this.func_217354_b(\u2603, \u2603)) continue;
                return false;
            }
        }
        return true;
    }

    public Dimension func_201675_m();
}

