/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTSizeTracker;

public class CompressedStreamTools {
    public static CompoundNBT func_74796_a(InputStream inputStream) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(inputStream)));){
            CompoundNBT compoundNBT = CompressedStreamTools.func_152456_a(dataInputStream, NBTSizeTracker.field_152451_a);
            return compoundNBT;
        }
    }

    public static void func_74799_a(CompoundNBT compoundNBT, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));){
            CompressedStreamTools.func_74800_a(compoundNBT, dataOutputStream);
        }
    }

    public static CompoundNBT func_74794_a(DataInputStream dataInputStream) throws IOException {
        return CompressedStreamTools.func_152456_a(dataInputStream, NBTSizeTracker.field_152451_a);
    }

    public static CompoundNBT func_152456_a(DataInput dataInput, NBTSizeTracker nBTSizeTracker) throws IOException {
        INBT iNBT = CompressedStreamTools.func_152455_a(dataInput, 0, nBTSizeTracker);
        if (iNBT instanceof CompoundNBT) {
            return (CompoundNBT)iNBT;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void func_74800_a(CompoundNBT compoundNBT, DataOutput dataOutput) throws IOException {
        CompressedStreamTools.func_150663_a(compoundNBT, dataOutput);
    }

    private static void func_150663_a(INBT iNBT, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(iNBT.func_74732_a());
        if (iNBT.func_74732_a() == 0) {
            return;
        }
        dataOutput.writeUTF("");
        iNBT.func_74734_a(dataOutput);
    }

    private static INBT func_152455_a(DataInput dataInput, int n, NBTSizeTracker nBTSizeTracker) throws IOException {
        byte by = dataInput.readByte();
        if (by == 0) {
            return new EndNBT();
        }
        dataInput.readUTF();
        INBT \u26032 = INBT.func_150284_a(by);
        try {
            \u26032.func_152446_a(dataInput, n, nBTSizeTracker);
        }
        catch (IOException \u26033) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26033, "Loading NBT data");
            CrashReportCategory \u26034 = crashReport.func_85058_a("NBT Tag");
            \u26034.func_71507_a("Tag type", by);
            throw new ReportedException(crashReport);
        }
        return \u26032;
    }
}

