/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.Java9BackportUtils;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.toposort.CyclePresentException;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModSorter {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<ModFile> modFiles;
    private List<ModInfo> sortedList;
    private Map<String, ModInfo> modIdNameLookup;

    private ModSorter(List<ModFile> modFiles) {
        this.modFiles = modFiles;
    }

    public static LoadingModList sort(List<ModFile> mods) {
        ModSorter ms = new ModSorter(mods);
        EarlyLoadingException earlyLoadingException = null;
        try {
            ms.findLanguages();
            ms.buildUniqueList();
            ms.verifyDependencyVersions();
            ms.sort();
        }
        catch (EarlyLoadingException ele) {
            earlyLoadingException = ele;
            ms.sortedList = Collections.emptyList();
        }
        return LoadingModList.of(ms.modFiles, ms.sortedList, earlyLoadingException);
    }

    private void findLanguages() {
        this.modFiles.forEach(ModFile::identifyLanguage);
    }

    private void sort() {
        List<ModFileInfo> sorted;
        MutableGraph graph = GraphBuilder.directed().build();
        AtomicInteger counter = new AtomicInteger();
        Map infos = this.modFiles.stream().map(ModFile::getModFileInfo).collect(Collectors.toMap(Function.identity(), e -> counter.incrementAndGet()));
        infos.keySet().forEach(i -> graph.addNode((Object)((ModFileInfo)i)));
        this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).map(IModInfo::getDependencies).flatMap(Collection::stream).forEach(dep -> this.addDependency((MutableGraph<ModFileInfo>)graph, (IModInfo.ModVersion)dep));
        try {
            sorted = TopologicalSort.topologicalSort(graph, Comparator.comparing(infos::get));
        }
        catch (CyclePresentException e2) {
            Set cycles = e2.getCycles();
            LOGGER.error(LogMarkers.LOADING, () -> buffer -> {
                buffer.append("Mod Sorting failed.\n");
                buffer.append("Detected Cycles: ");
                buffer.append(cycles);
                buffer.append('\n');
            });
            List<EarlyLoadingException.ExceptionData> dataList = cycles.stream().map(Collection::stream).map(stream -> stream.flatMap(modFileInfo -> modFileInfo.getMods().stream().map(IModInfo::getModId)).collect(Collectors.toList())).map(list -> new EarlyLoadingException.ExceptionData("fml.modloading.cycle", list)).collect(Collectors.toList());
            throw new EarlyLoadingException("Sorting error", e2, dataList);
        }
        this.sortedList = sorted.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toList());
        this.modFiles = sorted.stream().map(ModFileInfo::getFile).collect(Collectors.toList());
    }

    private void addDependency(MutableGraph<ModFileInfo> topoGraph, IModInfo.ModVersion dep) {
        ModFileInfo self = (ModFileInfo)dep.getOwner().getOwningFile();
        ModInfo targetModInfo = this.modIdNameLookup.get(dep.getModId());
        if (targetModInfo == null) {
            return;
        }
        ModFileInfo target = targetModInfo.getOwningFile();
        if (self == target) {
            return;
        }
        switch (dep.getOrdering()) {
            case BEFORE: {
                topoGraph.putEdge((Object)self, (Object)target);
                break;
            }
            case AFTER: {
                topoGraph.putEdge((Object)target, (Object)self);
                break;
            }
        }
    }

    private void buildUniqueList() {
        Stream<ModInfo> modInfos = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).map(ModInfo.class::cast);
        Map<String, List<ModInfo>> modIds = modInfos.collect(Collectors.groupingBy(IModInfo::getModId));
        List dupedMods = modIds.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toList());
        if (!dupedMods.isEmpty()) {
            List<EarlyLoadingException.ExceptionData> duplicateModErrors = dupedMods.stream().map(dm -> new EarlyLoadingException.ExceptionData("fml.modloading.dupedmod", ((List)dm.getValue()).get(0))).collect(Collectors.toList());
            throw new EarlyLoadingException("Duplicate mods found", null, duplicateModErrors);
        }
        this.modIdNameLookup = modIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (ModInfo)((List)e.getValue()).get(0)));
    }

    private void verifyDependencyVersions() {
        Map<String, ArtifactVersion> modVersions = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.toMap(IModInfo::getModId, IModInfo::getVersion));
        Map modVersionDependencies = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Java9BackportUtils.flatMapping(e -> e.getDependencies().stream(), Collectors.toList())));
        Set mandatoryModVersions = modVersionDependencies.values().stream().flatMap(Collection::stream).filter(mv -> mv.isMandatory() && mv.getSide().isCorrectSide()).collect(Collectors.toSet());
        LOGGER.debug(LogMarkers.LOADING, "Found {} mandatory requirements", (Object)mandatoryModVersions.size());
        Set missingVersions = mandatoryModVersions.stream().filter(mv -> this.modVersionMatches((IModInfo.ModVersion)mv, modVersions)).collect(Collectors.toSet());
        LOGGER.debug(LogMarkers.LOADING, "Found {} mandatory mod requirements missing", (Object)missingVersions.size());
        if (!missingVersions.isEmpty()) {
            List<EarlyLoadingException.ExceptionData> exceptionData = missingVersions.stream().map(mv -> new EarlyLoadingException.ExceptionData("fml.modloading.missingdependency", mv.getModId(), mv.getOwner().getModId(), mv.getVersionRange(), modVersions.getOrDefault(mv.getModId(), (ArtifactVersion)new DefaultArtifactVersion("null")))).collect(Collectors.toList());
            throw new EarlyLoadingException("Missing mods", null, exceptionData);
        }
    }

    private boolean modVersionMatches(IModInfo.ModVersion mv, Map<String, ArtifactVersion> modVersions) {
        return !modVersions.containsKey(mv.getModId()) || !mv.getVersionRange().containsVersion(modVersions.get(mv.getModId()));
    }
}

