/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.cable.TileCableEnergy;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.energy.CapabilityEnergy;

public class BlockCableEnergy
extends BlockBase {
    private static final EnumProperty<EnumConnectType> DOWN = EnumProperty.func_177709_a((String)"down", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> UP = EnumProperty.func_177709_a((String)"up", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> NORTH = EnumProperty.func_177709_a((String)"north", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> SOUTH = EnumProperty.func_177709_a((String)"south", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> WEST = EnumProperty.func_177709_a((String)"west", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> EAST = EnumProperty.func_177709_a((String)"east", EnumConnectType.class);
    public static final Map<Direction, EnumProperty<EnumConnectType>> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), p -> {
        p.put(Direction.NORTH, NORTH);
        p.put(Direction.EAST, EAST);
        p.put(Direction.SOUTH, SOUTH);
        p.put(Direction.WEST, WEST);
        p.put(Direction.UP, UP);
        p.put(Direction.DOWN, DOWN);
    });
    private static final double top = 16.0;
    private static final double bot = 0.0;
    private static final double C = 8.0;
    private static final double w = 2.0;
    private static final double sm = 6.0;
    private static final double lg = 10.0;
    private static final VoxelShape AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_UP = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape AABB_DOWN = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_NORTH = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_SOUTH = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape AABB_WEST = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_EAST = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    public BlockCableEnergy(Block.Properties properties) {
        super(properties);
    }

    public static BlockState cleanBlockState(BlockState state) {
        for (Direction d : Direction.values()) {
            EnumProperty<EnumConnectType> prop = FACING_TO_PROPERTY_MAP.get(d);
            if (state.func_177229_b(prop) != EnumConnectType.INVENTORY) continue;
            state = (BlockState)state.func_206870_a(prop, (Comparable)((Object)EnumConnectType.NONE));
        }
        return state;
    }

    private boolean shapeConnects(BlockState state, EnumProperty<EnumConnectType> dirctionProperty) {
        return ((EnumConnectType)((Object)state.func_177229_b(dirctionProperty))).equals((Object)EnumConnectType.CABLE) || ((EnumConnectType)((Object)state.func_177229_b(dirctionProperty))).equals((Object)EnumConnectType.INVENTORY);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = AABB;
        if (this.shapeConnects(state, UP)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_UP, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (this.shapeConnects(state, DOWN)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_DOWN, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b(WEST))).equals((Object)EnumConnectType.CABLE)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_WEST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b(EAST))).equals((Object)EnumConnectType.CABLE)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_EAST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b(NORTH))).equals((Object)EnumConnectType.CABLE)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_NORTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b(SOUTH))).equals((Object)EnumConnectType.CABLE)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_SOUTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCableEnergy();
    }

    public BlockState getExtendedState(BlockState state, IBlockReader world, BlockPos pos) {
        return super.getExtendedState(state, world, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        EnumProperty<EnumConnectType> property = FACING_TO_PROPERTY_MAP.get(facing);
        if (BlockCableEnergy.isEnergy(stateIn, facing, facingState, world, currentPos, facingPos)) {
            return (BlockState)stateIn.func_206870_a(property, (Comparable)((Object)EnumConnectType.CABLE));
        }
        return (BlockState)stateIn.func_206870_a(property, (Comparable)((Object)EnumConnectType.NONE));
    }

    private static boolean isEnergy(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == null) {
            return false;
        }
        TileEntity neighbor = world.func_175625_s(facingPos);
        return neighbor != null && neighbor.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).orElse(null) != null;
    }

    public static enum EnumConnectType implements IStringSerializable
    {
        NONE,
        CABLE,
        INVENTORY,
        BLOCKED;


        public boolean isHollow() {
            return this == NONE || this == BLOCKED;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

