/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.CyclicRegistry;
import com.lothrazar.cyclic.base.CustomEnergyStorage;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.battery.ContainerBattery;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileBattery
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 6400000;
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private int flowing;

    public TileBattery() {
        super(CyclicRegistry.batterytile);
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(6400000, 1600000);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT tag) {
        this.setFlowing(tag.func_74762_e("flowing"));
        CompoundNBT energyTag = tag.func_74775_l("energy");
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)energyTag));
        super.func_145839_a(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("flowing", this.getFlowing());
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerBattery(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public void func_73660_a() {
        if (this.getFlowing() == 1) {
            this.tickCableFlow();
        }
    }

    private void tickCableFlow() {
        List rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());
        Collections.shuffle(rawList);
        for (Integer i : rawList) {
            Direction exportToSide = Direction.values()[i];
            this.moveEnergy(exportToSide, 1600000);
        }
    }

    public int getFlowing() {
        return this.flowing;
    }

    public void setFlowing(int flowing) {
        this.flowing = flowing;
    }

    @Override
    public void setField(int field, int value) {
        this.flowing = value;
    }
}

