/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.base.BlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockSpikes
extends BlockBase {
    public static final BooleanProperty ACTIVATED = BooleanProperty.func_177716_a((String)"lit");
    private static final float LARGE = 0.9375f;
    private static final float SMALL = 0.0625f;
    private static final VoxelShape NORTH_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.9375, (double)15.0, (double)15.0, (double)1.0);
    private static final VoxelShape EAST_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.9375, (double)15.0, (double)15.0);
    private static final VoxelShape SOUTH_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)0.9375);
    private static final VoxelShape WEST_BOX = Block.func_208617_a((double)0.9375, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape UP_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)0.9375, (double)15.0);
    private static final VoxelShape DOWN_BOX = Block.func_208617_a((double)0.0, (double)0.9375, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    protected static final VoxelShape UNPRESSED_AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    public BlockSpikes(Block.Properties properties) {
        super(properties.func_200943_b(1.1f));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)) {
            case NORTH: {
                return NORTH_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
            case UP: {
                return UP_BOX;
            }
            case DOWN: {
                return DOWN_BOX;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && ((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            entity.func_70097_a(DamageSource.field_76367_g, this.getDamage());
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue() && world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        } else if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
    }

    private float getDamage() {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing;
        BlockPos pos;
        World worldIn = context.func_195991_k();
        return worldIn.func_180495_p((pos = context.func_195995_a()).func_177972_a((facing = context.func_196000_l()).func_176734_d())).func_200132_m() ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing)).func_206870_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN)).func_206870_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H}).func_206894_a(new IProperty[]{ACTIVATED});
    }
}

