/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiSizableBox;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;

public class TexUtils {
    public static final ResourceLocation BLOCKS_TEX = AtlasTexture.field_110575_b;
    public static final AbstractGui DRAWER = new AbstractGui(){};

    public static GuiSizableBox generateSlotStyle(VLID loc, int x, int y) {
        return TexUtils.genSizableBox(loc, x, y, 2, 2);
    }

    public static GuiSizableBox generateSearchBoxStyle(VLID loc, int x, int y) {
        return TexUtils.genSizableBox(loc, x, y, 2, 2);
    }

    public static GuiSizableBox generateGuiBGStyle(VLID loc, int x, int y) {
        return TexUtils.genSizableBox(loc, x, y, 4, 4);
    }

    public static GuiSizableBox genSizableBox(VLID loc, int x, int y, int w, int h) {
        GuiSizableBox ss = new GuiSizableBox(loc, w, h);
        int xs0 = x + w * 0;
        int xs1 = x + w * 1;
        int xs2 = x + w * 2;
        int xe0 = x + w * 1;
        int xe1 = x + w * 2;
        int xe2 = x + w * 3;
        int ys0 = y + h * 0;
        int ys1 = y + h * 1;
        int ys2 = y + h * 2;
        int ye0 = y + h * 1;
        int ye1 = y + h * 2;
        int ye2 = y + h * 3;
        ss.setGuiTexture(GuiSizableBox.BoxLocation.TOP_LEFT, new GuiTexture(loc, xs0, ys0, xe0, ye0));
        ss.setGuiTexture(GuiSizableBox.BoxLocation.TOP_MID, new GuiTexture(loc, xs1, ys0, xe1, ye0));
        ss.setGuiTexture(GuiSizableBox.BoxLocation.TOP_RIGHT, new GuiTexture(loc, xs2, ys0, xe2, ye0));
        ss.setGuiTexture(GuiSizableBox.BoxLocation.MID_LEFT, new GuiTexture(loc, xs0, ys1, xe0, ye1));
        ss.setGuiTexture(GuiSizableBox.BoxLocation.MID, new GuiTexture(loc, xs1, ys1, xe1, ye1));
        ss.setGuiTexture(GuiSizableBox.BoxLocation.MID_RIGHT, new GuiTexture(loc, xs2, ys1, xe2, ye1));
        ss.setGuiTexture(GuiSizableBox.BoxLocation.BOT_LEFT, new GuiTexture(loc, xs0, ys2, xe0, ye2));
        ss.setGuiTexture(GuiSizableBox.BoxLocation.BOT_MID, new GuiTexture(loc, xs1, ys2, xe1, ye2));
        ss.setGuiTexture(GuiSizableBox.BoxLocation.BOT_RIGHT, new GuiTexture(loc, xs2, ys2, xe2, ye2));
        return ss;
    }

    public static void setColor(int mcColor) {
        float f3 = (float)(mcColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(mcColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(mcColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(mcColor & 0xFF) / 255.0f;
        GlStateManager.color4f((float)f, (float)f1, (float)f2, (float)f3);
    }

    public static GuiTexture getTextureLoc(VLID loc, int x, int y, int w, int h) {
        return new GuiTexture(loc, x, y, x + w, y + h);
    }

    public static void renderTexLocation(GuiTexture tex, IElementContainer gui, int x, int y) {
        TexUtils.bindTexture(tex.texture);
        GuiUtils.drawTexturedRect(DRAWER, x, y, tex.startX, tex.startY, tex.width, tex.height);
    }

    public static void renderTexLocationScaled(GuiTexture tex, IElementContainer gui, int x, int y, int w, int h) {
        TexUtils.bindTexture(tex.texture);
        GuiUtils.drawTexturedRect(DRAWER, x, y, tex.startX, tex.startY, tex.width, tex.height, w, h);
    }

    public static void renderSizableBox(GuiSizableBox sb, IElementContainer gui, int x, int y, int w, int h) {
        TexUtils.bindTexture(sb.getResourceLocation());
        if (sb.getMiddleRepeatable()) {
            TexUtils.renderSizableBoxRepeatableMiddle(sb, gui, x, y, w, h);
        } else {
            TexUtils.renderSizableBoxStretchableMiddle(sb, gui, x, y, w, h);
        }
    }

    protected static void bindTexture(VLID res) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)res);
    }

    private static void renderSizableBoxStretchableMiddle(GuiSizableBox sb, IElementContainer gui, int x, int y, int w, int h) {
        int middleW = w - 2 * sb.getUnitX();
        int middleH = h - 2 * sb.getUnitY();
        int tsy = y;
        int msy = y + sb.getUnitY();
        int bsy = y + (h - 1 * sb.getUnitY());
        int lsx = x;
        int msx = x + sb.getUnitX();
        int rsx = x + (w - 1 * sb.getUnitX());
        Screen guic = gui.getGui();
        GuiTexture topl = sb.getGuiTexture(GuiSizableBox.BoxLocation.TOP_LEFT);
        GuiUtils.drawTexturedRect(DRAWER, lsx, tsy, topl.startX, topl.startY, topl.width, topl.height, topl.getTexW(), topl.getTexH());
        GuiTexture topm = sb.getGuiTexture(GuiSizableBox.BoxLocation.TOP_MID);
        GuiUtils.drawTexturedRect(DRAWER, msx, tsy, topm.startX, topm.startY, topm.width, topm.height, middleW, sb.getUnitY(), topm.getTexW(), topm.getTexH());
        GuiTexture topr = sb.getGuiTexture(GuiSizableBox.BoxLocation.TOP_RIGHT);
        GuiUtils.drawTexturedRect(DRAWER, rsx, tsy, topr.startX, topr.startY, topr.width, topr.height, topr.getTexW(), topr.getTexH());
        GuiTexture midl = sb.getGuiTexture(GuiSizableBox.BoxLocation.MID_LEFT);
        GuiUtils.drawTexturedRect(DRAWER, lsx, msy, midl.startX, midl.startY, midl.width, midl.height, sb.getUnitX(), middleH, midl.getTexW(), midl.getTexH());
        GuiTexture midm = sb.getGuiTexture(GuiSizableBox.BoxLocation.MID);
        GuiUtils.drawTexturedRect(DRAWER, msx, msy, midm.startX, midm.startY, midm.width, midm.height, middleW, middleH, midm.getTexW(), midm.getTexH());
        GuiTexture midr = sb.getGuiTexture(GuiSizableBox.BoxLocation.MID_RIGHT);
        GuiUtils.drawTexturedRect(DRAWER, rsx, msy, midr.startX, midr.startY, midr.width, midr.height, sb.getUnitX(), middleH, midr.getTexW(), midr.getTexH());
        GuiTexture botl = sb.getGuiTexture(GuiSizableBox.BoxLocation.BOT_LEFT);
        GuiUtils.drawTexturedRect(DRAWER, lsx, bsy, botl.startX, botl.startY, botl.width, botl.height, botl.getTexW(), botl.getTexH());
        GuiTexture botm = sb.getGuiTexture(GuiSizableBox.BoxLocation.BOT_MID);
        GuiUtils.drawTexturedRect(DRAWER, msx, bsy, botm.startX, botm.startY, botm.width, botm.height, middleW, sb.getUnitY(), botm.getTexW(), botm.getTexH());
        GuiTexture botr = sb.getGuiTexture(GuiSizableBox.BoxLocation.BOT_RIGHT);
        GuiUtils.drawTexturedRect(DRAWER, rsx, bsy, botr.startX, botr.startY, botr.width, botr.height, botr.getTexW(), botr.getTexH());
    }

    private static void renderSizableBoxRepeatableMiddle(GuiSizableBox sb, IElementContainer gui, int x, int y, int w, int h) {
    }
}

