/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.VLEleContainerBase;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.NotNull;

public abstract class VLEleContainerBaseList
extends VLEleContainerBase {
    protected List<IElement> elements = Lists.newArrayList();

    public VLEleContainerBaseList(IElementContainer owner, String id) {
        super(owner, id);
    }

    @Override
    public Screen getGui() {
        return this.getContainer().getGui();
    }

    @Override
    @NotNull
    protected List<IElement> getElementList() {
        return this.elements;
    }

    public final void addElement(IElement element) {
        if (element != null) {
            this.elements.add(element);
            if (element instanceof IElementContainer) {
                ((IElementContainer)((Object)element)).initContainer();
            }
        }
    }

    @Override
    public void load(CompoundNBT nbt) {
        CompoundNBT ct = nbt.func_74775_l(this.getID());
        for (IElement ele : this.elements) {
            ele.load(ct);
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        CompoundNBT ct = nbt.func_74775_l(this.getID());
        for (IElement ele : this.elements) {
            ele.save(ct);
        }
        return nbt;
    }

    @Override
    public void update() {
        GuiUtils.updateAll(this.elements);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawBackground(this.elements, mouseX, mouseY, partialTicks, this);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        GuiUtils.drawForeground(this.elements, mouseX, mouseY, this);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseClickedCheckAll(this.elements, mouseX, mouseY, mouseButton, this);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseReleasedCheckAll(this.elements, mouseX, mouseY, mouseButton, this);
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        GuiUtils.mouseDraggedCheckAll(this.elements, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd, this);
        return false;
    }

    @Override
    public boolean mouseScrolled(double scrolled) {
        GuiUtils.mouseScrolledCheckAll(this.elements, scrolled, this);
        return false;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        GuiUtils.keyPressedCheckAll(this.elements, key, scanCode, modifiers, this);
        return false;
    }

    @Override
    public boolean keyReleased(int key, int scanCode, int modifiers) {
        GuiUtils.keyReleasedCheckAll(this.elements, key, scanCode, modifiers, this);
        return false;
    }

    @Override
    public boolean charTyped(char ch, int modifiers) {
        GuiUtils.charTypedCheckAll(this.elements, ch, modifiers, this);
        return false;
    }

    @Override
    public void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(this.elements, current);
    }
}

