/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.init.ModFluids;
import net.silentchaos512.mechanisms.item.BatteryItem;
import net.silentchaos512.mechanisms.item.CraftingItems;
import net.silentchaos512.mechanisms.item.DebugItem;
import net.silentchaos512.mechanisms.item.MachineUpgrades;
import net.silentchaos512.mechanisms.item.WrenchItem;

public final class ModItems {
    public static BatteryItem battery;
    public static BucketItem oilBucket;
    public static BucketItem dieselBucket;
    static final Map<String, BlockItem> BLOCKS_TO_REGISTER;

    private ModItems() {
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        BLOCKS_TO_REGISTER.forEach(ModItems::register);
        battery = ModItems.register("battery", new BatteryItem());
        oilBucket = ModItems.register("oil_bucket", ModItems.createBucketItem(() -> ModFluids.OIL));
        dieselBucket = ModItems.register("diesel_bucket", ModItems.createBucketItem(() -> ModFluids.DIESEL));
        Arrays.stream(CraftingItems.values()).forEach(c -> ModItems.register(c.getName(), c.func_199767_j()));
        Arrays.stream(MachineUpgrades.values()).forEach(u -> ModItems.register(u.getName(), u.func_199767_j()));
        ModItems.register("wrench", new WrenchItem());
        ModItems.register("debug_item", new DebugItem());
    }

    private static BucketItem createBucketItem(Supplier<FlowingFluid> fluid) {
        return new BucketItem(fluid, new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP).func_200917_a(1).func_200919_a(Items.field_151133_ar));
    }

    private static <T extends Item> T register(String name, T item) {
        ResourceLocation id = SilentMechanisms.getId(name);
        item.setRegistryName(id);
        ForgeRegistries.ITEMS.register(item);
        return item;
    }

    static {
        BLOCKS_TO_REGISTER = new LinkedHashMap<String, BlockItem>();
    }
}

