/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.refining;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.crafting.refining.RefiningRecipe;
import net.silentchaos512.mechanisms.network.SyncRefiningRecipesPacket;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class RefiningRecipeManager
implements IResourceManagerReloadListener {
    public static final RefiningRecipeManager INSTANCE = new RefiningRecipeManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"RefiningRecipeManager");
    private static final String DATA_PATH = "silents_mechanisms_refinement";
    private static final Map<ResourceLocation, RefiningRecipe> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<ResourceLocation> ERROR_LIST = new ArrayList<ResourceLocation>();

    private RefiningRecipeManager() {
    }

    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection<ResourceLocation> resources = RefiningRecipeManager.getAllResources(resourceManager);
        if (resources.isEmpty()) {
            return;
        }
        MAP.clear();
        ERROR_LIST.clear();
        SilentMechanisms.LOGGER.info(MARKER, "Reloading refining recipe files");
        for (ResourceLocation id : resources) {
            String path = id.func_110623_a().substring(DATA_PATH.length() + 1, id.func_110623_a().length() - ".json".length());
            ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
            try {
                IResource iresource = resourceManager.func_199002_a(id);
                Throwable throwable = null;
                try {
                    JsonObject json;
                    if (SilentMechanisms.LOGGER.isTraceEnabled()) {
                        SilentMechanisms.LOGGER.trace(MARKER, "Found likely refine recipe: {}, trying to read as {}", (Object)id, (Object)name);
                    }
                    if ((json = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class)) == null) {
                        SilentMechanisms.LOGGER.error(MARKER, "Could not load refining recipe {} as it's null or empty", (Object)name);
                        continue;
                    }
                    if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                        SilentMechanisms.LOGGER.info("Skipping loading refining recipe {} as it's conditions were not met", (Object)name);
                        continue;
                    }
                    RefiningRecipe recipe = RefiningRecipe.deserialize(name, json);
                    RefiningRecipeManager.addRecipe(recipe);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException ex) {
                SilentMechanisms.LOGGER.error(MARKER, "Parsing error loading refining recipe {}", (Object)name, (Object)ex);
                ERROR_LIST.add(name);
            }
            catch (IOException ex) {
                SilentMechanisms.LOGGER.error(MARKER, "Could not read refining recipe {}", (Object)name, (Object)ex);
                ERROR_LIST.add(name);
            }
        }
        SilentMechanisms.LOGGER.info(MARKER, "Registered {} refining recipes", (Object)MAP.size());
    }

    private static Collection<ResourceLocation> getAllResources(IResourceManager resourceManager) {
        return new ArrayList<ResourceLocation>(resourceManager.func_199003_a(DATA_PATH, s -> s.endsWith(".json")));
    }

    private static void addRecipe(RefiningRecipe recipe) {
        if (MAP.containsKey(recipe.getId())) {
            throw new IllegalStateException("Duplicate refining recipe " + recipe.getId());
        }
        MAP.put(recipe.getId(), recipe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<RefiningRecipe> getValues() {
        Map<ResourceLocation, RefiningRecipe> map = MAP;
        synchronized (map) {
            return MAP.values();
        }
    }

    @Nullable
    public static RefiningRecipe get(ResourceLocation id) {
        return MAP.get(id);
    }

    @Nullable
    public static RefiningRecipe get(String id) {
        ResourceLocation recipeId = ResourceLocation.func_208304_a((String)id);
        return recipeId != null ? RefiningRecipeManager.get(recipeId) : null;
    }

    public static void handleSyncPacket(SyncRefiningRecipesPacket packet, Supplier<NetworkEvent.Context> context) {
        MAP.clear();
        SilentMechanisms.LOGGER.info("Read {} refining recipes from server", (Object)MAP.size());
        context.get().setPacketHandled(true);
    }

    public static Collection<ITextComponent> getErrorMessages(ServerPlayerEntity player) {
        if (!ERROR_LIST.isEmpty()) {
            String listStr = ERROR_LIST.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            return ImmutableList.of((Object)new StringTextComponent("[Silent's Mechanisms] The following refining recipes failed to load, check your log file:").func_211708_a(TextFormatting.RED), (Object)new StringTextComponent(listStr));
        }
        return ImmutableList.of();
    }
}

