/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.refinery;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;
import net.silentchaos512.mechanisms.block.refinery.RefineryContainer;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;

public class RefineryTileEntity
extends AbstractMachineBaseTileEntity
implements IFluidHandler {
    public static final int FIELDS_COUNT = 10;
    private final FluidTank[] tanks = (FluidTank[])IntStream.range(0, 5).mapToObj(k -> new FluidTank(10000)).toArray(FluidTank[]::new);
    private final LazyOptional<IFluidHandler> fluidHandlerCap = LazyOptional.of(() -> this);

    public RefineryTileEntity() {
        super(ModTileEntities.refinery, 2, MachineTier.STANDARD.getEnergyCapacity(), 500, 0, MachineTier.BASIC);
    }

    public FluidStack getFluid(int tank) {
        if (tank < 0 || tank >= this.tanks.length) {
            return FluidStack.EMPTY;
        }
        return this.tanks[tank].getFluid();
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack input = this.func_70301_a(0);
        if (!input.func_190926_b() && input.func_77973_b() instanceof BucketItem) {
            this.tryFillTankWithBucket(input);
        }
    }

    private void tryFillTankWithBucket(ItemStack input) {
        Fluid fluid = ((BucketItem)input.func_77973_b()).getFluid();
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        if (this.canAcceptFluidBucket(input, fluidStack)) {
            this.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.sendUpdate(this.func_195044_w(), true);
            this.func_70299_a(0, input.getContainerItem());
            ItemStack input2 = this.func_70301_a(0);
            if (!input2.func_190926_b()) {
                ItemStack output = this.func_70301_a(1);
                if (output.func_190926_b()) {
                    this.func_70299_a(1, input2);
                    this.func_70299_a(0, ItemStack.field_190927_a);
                } else if (InventoryUtils.canItemsStack((ItemStack)this.func_70301_a(0), (ItemStack)output)) {
                    output.func_190917_f(1);
                    input2.func_190918_g(1);
                }
            }
        }
    }

    private boolean canAcceptFluidBucket(ItemStack input, FluidStack fluid) {
        ItemStack output = this.func_70301_a(1);
        return !(!this.isFluidValid(0, fluid) || this.fill(fluid, IFluidHandler.FluidAction.SIMULATE) != 1000 || !output.func_190926_b() && !InventoryUtils.canItemsStack((ItemStack)input.getContainerItem(), (ItemStack)output) || !output.func_190926_b() && output.func_190916_E() >= output.func_77976_d());
    }

    protected void sendUpdate(BlockState newState, boolean force) {
        if (this.field_145850_b == null) {
            return;
        }
        BlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (oldState != newState || force) {
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
            this.field_145850_b.func_184138_a(this.field_174879_c, oldState, newState, 3);
        }
    }

    public int[] func_180463_a(Direction side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index == 0 && itemStackIn.func_77973_b() instanceof BucketItem;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "refinery", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new RefineryContainer(id, player, this, this.fields);
    }

    @Override
    public void func_145839_a(CompoundNBT tags) {
        SilentMechanisms.LOGGER.debug("read");
        for (int i = 0; i < this.tanks.length; ++i) {
            String key = "Tank" + i;
            if (!tags.func_74764_b(key)) continue;
            this.tanks[i].setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)tags.func_74775_l(key)));
        }
        super.func_145839_a(tags);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        SilentMechanisms.LOGGER.debug("write");
        for (int i = 0; i < this.tanks.length; ++i) {
            tags.func_218657_a("Tank" + i, (INBT)this.tanks[i].writeToNBT(new CompoundNBT()));
        }
        return super.func_189515_b(tags);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        SilentMechanisms.LOGGER.debug("onDataPacket");
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        for (int i = 0; i < this.tanks.length; ++i) {
            String key = "Tank" + i;
            if (!tags.func_74764_b(key)) continue;
            this.tanks[i].setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)tags.func_74775_l(key)));
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        SilentMechanisms.LOGGER.debug("getUpdateTag");
        CompoundNBT tags = super.func_189517_E_();
        for (int i = 0; i < this.tanks.length; ++i) {
            tags.func_218657_a("Tank" + i, (INBT)this.tanks[i].writeToNBT(new CompoundNBT()));
        }
        return tags;
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.fluidHandlerCap.invalidate();
    }

    public int getTanks() {
        return this.tanks.length;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.tanks.length) {
            return FluidStack.EMPTY;
        }
        return this.tanks[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.tanks.length) {
            return 0;
        }
        return this.tanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank < 0 || tank >= this.tanks.length) {
            return false;
        }
        return this.tanks[tank].isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack fluidInTank = this.tanks[0].getFluid();
        if (this.isFluidValid(0, resource) && (fluidInTank.isEmpty() || resource.isFluidEqual(fluidInTank))) {
            if (action != IFluidHandler.FluidAction.SIMULATE) {
                this.field_145850_b.func_180501_a(this.field_174879_c, this.func_195044_w(), 3);
            }
            return this.tanks[0].fill(resource, action);
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        for (int i = 1; i < this.tanks.length; ++i) {
            if (!resource.isFluidEqual(this.tanks[i].getFluid())) continue;
            return this.tanks[i].drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (int i = 1; i < this.tanks.length; ++i) {
            if (this.tanks[i].getFluidAmount() <= 0) continue;
            return this.tanks[i].drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }
}

