/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;
import net.silentchaos512.mechanisms.block.IMachineInventory;
import net.silentchaos512.mechanisms.capability.EnergyStorageImpl;
import net.silentchaos512.mechanisms.item.MachineUpgradeItem;
import net.silentchaos512.mechanisms.item.MachineUpgrades;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.utils.EnumUtils;

public abstract class AbstractMachineTileEntity<R extends IRecipe<?>>
extends AbstractMachineBaseTileEntity
implements IMachineInventory {
    public static final int FIELDS_COUNT = 7;
    protected float progress;
    protected int processTime;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractMachineTileEntity.this.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return AbstractMachineTileEntity.this.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return AbstractMachineTileEntity.this.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return AbstractMachineTileEntity.this.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
                case 4: {
                    return AbstractMachineTileEntity.this.redstoneMode.ordinal();
                }
                case 5: {
                    return (int)AbstractMachineTileEntity.this.progress;
                }
                case 6: {
                    return AbstractMachineTileEntity.this.processTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 4: {
                    AbstractMachineTileEntity.this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)value, (Enum)RedstoneMode.IGNORED);
                    break;
                }
                case 5: {
                    AbstractMachineTileEntity.this.progress = value;
                    break;
                }
                case 6: {
                    AbstractMachineTileEntity.this.processTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 7;
        }
    };

    protected AbstractMachineTileEntity(TileEntityType<?> typeIn, int inventorySize, MachineTier tier) {
        super(typeIn, inventorySize, tier.getEnergyCapacity(), 500, 0, tier);
    }

    @Override
    public EnergyStorageImpl getEnergyImpl() {
        return super.getEnergyImpl();
    }

    protected abstract int getEnergyUsedPerTick();

    protected BlockState getActiveState(BlockState currentState) {
        return (BlockState)currentState.func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(true));
    }

    protected BlockState getInactiveState(BlockState currentState) {
        return (BlockState)currentState.func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(false));
    }

    protected abstract int[] getOutputSlots();

    @Nullable
    protected abstract R getRecipe();

    protected abstract int getProcessTime(R var1);

    protected float getProcessSpeed() {
        int speedUpgrades = this.getUpgradeCount(MachineUpgrades.PROCESSING_SPEED);
        return this.tier.getProcessingSpeed() + (float)speedUpgrades * 0.5f;
    }

    protected abstract Collection<ItemStack> getProcessResults(R var1);

    protected Collection<ItemStack> getPossibleProcessResult(R recipe) {
        return this.getProcessResults(recipe);
    }

    public int getUpgradeCount(IItemProvider upgradeItem) {
        int count = 0;
        for (int i = this.func_70302_i_() - this.tier.getUpgradeSlots(); i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != upgradeItem.func_199767_j()) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    private float getUpgradesEnergyMultiplier() {
        float cost = 1.0f;
        for (int i = this.func_70302_i_() - this.tier.getUpgradeSlots(); i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof MachineUpgradeItem)) continue;
            cost += (float)stack.func_190916_E() * ((MachineUpgradeItem)stack.func_77973_b()).getUpgrade().getEnergyUsageMultiplier();
        }
        return cost;
    }

    @Override
    public int getInputSlotCount() {
        return 1;
    }

    protected void sendUpdate(BlockState newState) {
        if (this.field_145850_b == null) {
            return;
        }
        BlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (oldState != newState) {
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
            this.field_145850_b.func_184138_a(this.field_174879_c, oldState, newState, 3);
        }
    }

    protected void setInactiveState() {
        if (this.field_145850_b == null) {
            return;
        }
        this.progress = 0.0f;
        this.sendUpdate(this.getInactiveState(this.field_145850_b.func_180495_p(this.field_174879_c)));
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        R recipe = this.getRecipe();
        if (recipe != null && this.canMachineRun(recipe)) {
            this.processTime = this.getProcessTime(recipe);
            this.progress += this.getProcessSpeed();
            this.energy.consumeEnergy((int)((float)this.getEnergyUsedPerTick() * this.getUpgradesEnergyMultiplier()));
            if (this.progress >= (float)this.processTime) {
                this.getProcessResults(recipe).forEach(this::storeResultItem);
                this.consumeIngredients(recipe);
                if (this.getRecipe() == null) {
                    this.setInactiveState();
                } else {
                    this.progress = 0.0f;
                }
            } else {
                this.sendUpdate(this.getActiveState(this.field_145850_b.func_180495_p(this.field_174879_c)));
            }
        } else {
            this.setInactiveState();
        }
    }

    private boolean canMachineRun(R recipe) {
        return this.field_145850_b != null && this.getEnergyStored() >= this.getEnergyUsedPerTick() && this.hasRoomInOutput(this.getPossibleProcessResult(recipe)) && this.redstoneMode.shouldRun(this.field_145850_b.func_175687_A(this.field_174879_c) > 0);
    }

    private boolean hasRoomInOutput(Iterable<ItemStack> results) {
        for (ItemStack stack : results) {
            if (this.hasRoomForOutputItem(stack)) continue;
            return false;
        }
        return true;
    }

    private boolean hasRoomForOutputItem(ItemStack stack) {
        for (int i : this.getOutputSlots()) {
            ItemStack output = this.func_70301_a(i);
            if (!AbstractMachineTileEntity.canItemsStack(stack, output)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canItemsStack(ItemStack a, ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) && a.func_190916_E() + b.func_190916_E() <= a.func_77976_d();
    }

    private void storeResultItem(ItemStack stack) {
        for (int i : this.getOutputSlots()) {
            ItemStack output = this.func_70301_a(i);
            if (!AbstractMachineTileEntity.canItemsStack(stack, output)) continue;
            if (output.func_190926_b()) {
                this.func_70299_a(i, stack);
            } else {
                output.func_190920_e(output.func_190916_E() + stack.func_190916_E());
            }
            return;
        }
    }

    protected void consumeIngredients(R recipe) {
        this.func_70298_a(0, 1);
    }

    @Override
    public IIntArray getFields() {
        return this.fields;
    }

    @Override
    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        this.progress = tags.func_74762_e("Progress");
        this.processTime = tags.func_74762_e("ProcessTime");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        tags.func_74768_a("Progress", (int)this.progress);
        tags.func_74768_a("ProcessTime", this.processTime);
        return tags;
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        this.progress = tags.func_74762_e("Progress");
        this.processTime = tags.func_74762_e("ProcessTime");
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        tags.func_74768_a("Progress", (int)this.progress);
        tags.func_74768_a("ProcessTime", this.processTime);
        return tags;
    }
}

