/*
 * Decompiled with CFR 0.152.
 */
package atm.bloodworkxgaming.serverstarter.packtype.curse;

import atm.bloodworkxgaming.serverstarter.InternetManager;
import atm.bloodworkxgaming.serverstarter.ServerStarter;
import atm.bloodworkxgaming.serverstarter.config.ConfigFile;
import atm.bloodworkxgaming.serverstarter.logger.PrimitiveLogger;
import atm.bloodworkxgaming.serverstarter.packtype.AbstractZipbasedPackType;
import atm.bloodworkxgaming.serverstarter.packtype.AbstractZipbasedPackTypeKt;
import atm.bloodworkxgaming.serverstarter.packtype.curse.ModEntryRaw;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0014J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0014J\b\u0010\u0017\u001a\u00020\rH\u0014J\u0016\u0010\u0018\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0002J<\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Latm/bloodworkxgaming/serverstarter/packtype/curse/CursePackType;", "Latm/bloodworkxgaming/serverstarter/packtype/AbstractZipbasedPackType;", "configFile", "Latm/bloodworkxgaming/serverstarter/config/ConfigFile;", "(Latm/bloodworkxgaming/serverstarter/config/ConfigFile;)V", "forgeVersion", "", "mcVersion", "oldFiles", "Ljava/io/File;", "cleanUrl", "url", "downloadMods", "", "mods", "", "Latm/bloodworkxgaming/serverstarter/packtype/curse/ModEntryRaw;", "getForgeVersion", "getMCVersion", "handleZip", "file", "pathMatchers", "Ljava/nio/file/PathMatcher;", "postProcessing", "processMods", "", "processSingleMod", "mod", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "totalCount", "", "fallbackList", "", "ignorePatterns", "Ljava/util/regex/Pattern;", "serverstarter"})
public class CursePackType
extends AbstractZipbasedPackType {
    private String forgeVersion;
    private String mcVersion;
    private final File oldFiles;
    private final ConfigFile configFile;

    @Override
    @NotNull
    protected String cleanUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        if (StringsKt.contains$default((CharSequence)url, "curseforge.com", false, 2, null) && !StringsKt.endsWith$default(url, "/download", false, 2, null)) {
            return url + "/download";
        }
        return url;
    }

    @Override
    @NotNull
    public String getForgeVersion() {
        return this.forgeVersion;
    }

    @Override
    @NotNull
    public String getMCVersion() {
        return this.mcVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleZip(@NotNull File file, @NotNull List<? extends PathMatcher> pathMatchers) throws IOException {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(pathMatchers, "pathMatchers");
        FileUtils.deleteDirectory(this.oldFiles);
        File modsFolder = new File(this.getBasePath() + "mods/");
        if (modsFolder.exists()) {
            FileUtils.moveDirectory(modsFolder, new File(this.oldFiles, "mods"));
        }
        PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Moved the mods folder", false, 2, null);
        PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Starting to unzip files.", false, 2, null);
        try {
            Closeable closeable = new ZipInputStream(new FileInputStream(file));
            Throwable throwable = null;
            try {
                ZipInputStream zis = (ZipInputStream)closeable;
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    ServerStarter.Companion.getLOGGER().info("Entry in zip: " + entry, true);
                    String name = entry.getName();
                    if (Intrinsics.areEqual(name, "manifest.json")) {
                        AbstractZipbasedPackTypeKt.writeToFile(zis, new File(this.getBasePath() + "manifest.json"));
                    }
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull(string, "name");
                    if (StringsKt.startsWith$default(string, "overrides/", false, 2, null)) {
                        String path;
                        boolean bl;
                        block22: {
                            String string2;
                            Intrinsics.checkExpressionValueIsNotNull(entry.getName(), "entry.name");
                            int n = 10;
                            String string3 = string2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            Intrinsics.checkExpressionValueIsNotNull(string3.substring(n), "(this as java.lang.String).substring(startIndex)");
                            Iterable $receiver$iv = pathMatchers;
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $receiver$iv) {
                                    PathMatcher it = (PathMatcher)element$iv;
                                    if (!it.matches(Paths.get(path, new String[0]))) continue;
                                    bl = true;
                                    break block22;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            ServerStarter.Companion.getLOGGER().info("Skipping " + path + " as it is on the ignore List.", true);
                        } else if (!StringsKt.endsWith$default(name, "/", false, 2, null)) {
                            File outfile = new File(this.getBasePath() + path);
                            ServerStarter.Companion.getLOGGER().info("Copying zip entry to = " + outfile, true);
                            File file2 = outfile.getParentFile();
                            if (file2 != null) {
                                file2.mkdirs();
                            }
                            AbstractZipbasedPackTypeKt.writeToFile(zis, outfile);
                        } else if (Intrinsics.areEqual(name, "overrides/") ^ true) {
                            File newFolder = new File(this.getBasePath() + path);
                            if (newFolder.exists()) {
                                FileUtils.moveDirectory(newFolder, new File(this.oldFiles, path));
                            }
                            ServerStarter.Companion.getLOGGER().info("Folder moved: " + newFolder.getAbsolutePath(), true);
                        }
                    }
                    entry = zis.getNextEntry();
                }
                zis.closeEntry();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            ServerStarter.Companion.getLOGGER().error("Could not unzip files", e);
        }
        PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Done unzipping the files.", false, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postProcessing() throws IOException {
        ArrayList<ModEntryRaw> mods = new ArrayList<ModEntryRaw>();
        Closeable closeable = new InputStreamReader((InputStream)new FileInputStream(new File(this.getBasePath() + "manifest.json")), "utf-8");
        Throwable throwable = null;
        try {
            Object object;
            JsonArray loaders;
            InputStreamReader reader = (InputStreamReader)closeable;
            JsonElement jsonElement = new JsonParser().parse(reader);
            Intrinsics.checkExpressionValueIsNotNull(jsonElement, "JsonParser().parse(reader)");
            JsonObject json = jsonElement.getAsJsonObject();
            ServerStarter.Companion.getLOGGER().info("manifest JSON Object: " + json, true);
            JsonObject mcObj = json.getAsJsonObject("minecraft");
            CharSequence charSequence = this.mcVersion;
            if (charSequence.length() == 0) {
                JsonPrimitive jsonPrimitive = mcObj.getAsJsonPrimitive("version");
                Intrinsics.checkExpressionValueIsNotNull(jsonPrimitive, "mcObj.getAsJsonPrimitive(\"version\")");
                String string = jsonPrimitive.getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string, "mcObj.getAsJsonPrimitive(\"version\").asString");
                this.mcVersion = string;
            }
            if ((charSequence = (CharSequence)this.forgeVersion).length() == 0 && (loaders = mcObj.getAsJsonArray("modLoaders")).size() > 0) {
                String string;
                JsonElement jsonElement2 = loaders.get(0);
                Intrinsics.checkExpressionValueIsNotNull(jsonElement2, "loaders[0]");
                JsonPrimitive jsonPrimitive = jsonElement2.getAsJsonObject().getAsJsonPrimitive("id");
                Intrinsics.checkExpressionValueIsNotNull(jsonPrimitive, "loaders[0].asJsonObject.getAsJsonPrimitive(\"id\")");
                String string2 = jsonPrimitive.getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "loaders[0].asJsonObject.\u2026nPrimitive(\"id\").asString");
                object = string2;
                int n = 6;
                CursePackType cursePackType = this;
                Object object2 = object;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)object2).substring(n);
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
                cursePackType.forgeVersion = string = string3;
            }
            object = json.getAsJsonArray("files").iterator();
            while (object.hasNext()) {
                JsonElement jsonElement3;
                JsonElement jsonElement4 = jsonElement3 = object.next();
                Intrinsics.checkExpressionValueIsNotNull(jsonElement4, "jsonElement");
                JsonObject obj = jsonElement4.getAsJsonObject();
                JsonPrimitive jsonPrimitive = obj.getAsJsonPrimitive("projectID");
                Intrinsics.checkExpressionValueIsNotNull(jsonPrimitive, "obj.getAsJsonPrimitive(\"projectID\")");
                String string = jsonPrimitive.getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string, "obj.getAsJsonPrimitive(\"projectID\").asString");
                JsonPrimitive jsonPrimitive2 = obj.getAsJsonPrimitive("fileID");
                Intrinsics.checkExpressionValueIsNotNull(jsonPrimitive2, "obj.getAsJsonPrimitive(\"fileID\")");
                String string4 = jsonPrimitive2.getAsString();
                Intrinsics.checkExpressionValueIsNotNull(string4, "obj.getAsJsonPrimitive(\"fileID\").asString");
                mods.add(new ModEntryRaw(string, string4));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        this.downloadMods((List<ModEntryRaw>)mods);
    }

    private final void downloadMods(List<ModEntryRaw> mods) {
        HashSet ignoreSet = new HashSet();
        List ignoreListTemp = this.configFile.getInstall().getFormatSpecificSettingOrDefault("ignoreProject", null);
        if (ignoreListTemp != null) {
            for (Object o : ignoreListTemp) {
                if (o instanceof String) {
                    ignoreSet.add(o);
                }
                if (!(o instanceof Integer)) continue;
                ignoreSet.add(o.toString());
            }
        }
        ConcurrentLinkedQueue urls = new ConcurrentLinkedQueue();
        PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Requesting Download links from cursemeta.", false, 2, null);
        mods.parallelStream().forEach((Consumer)new Consumer<ModEntryRaw>(this, ignoreSet, urls){
            final /* synthetic */ CursePackType this$0;
            final /* synthetic */ HashSet $ignoreSet;
            final /* synthetic */ ConcurrentLinkedQueue $urls;

            public final void accept(ModEntryRaw mod) {
                if (!this.$ignoreSet.isEmpty() && this.$ignoreSet.contains(mod.getProjectID())) {
                    PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Skipping mod with projectID: " + mod.getProjectID(), false, 2, null);
                    return;
                }
                String url = CursePackType.access$getConfigFile$p(this.this$0).getInstall().getFormatSpecificSettingOrDefault("cursemeta", "https://cursemeta.dries007.net") + "/" + mod.getProjectID() + "/" + mod.getFileID() + ".json";
                ServerStarter.Companion.getLOGGER().info("Download url is: " + url, true);
                try {
                    Response res;
                    Request request = new Request.Builder().url(url).header("User-Agent", "All the mods server installer.").header("Content-Type", "application/json").build();
                    Response response = res = InternetManager.INSTANCE.getHttpClient().newCall(request).execute();
                    Intrinsics.checkExpressionValueIsNotNull(response, "res");
                    if (!response.isSuccessful()) {
                        throw (Throwable)new IOException("Request to " + url + " was not successful.");
                    }
                    ResponseBody responseBody = res.body();
                    if (responseBody == null) {
                        throw (Throwable)new IOException("Request to " + url + " returned a null body.");
                    }
                    ResponseBody body = responseBody;
                    JsonElement jsonElement = new JsonParser().parse(body.string());
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement, "JsonParser().parse(body.string())");
                    JsonObject jsonRes = jsonElement.getAsJsonObject();
                    ServerStarter.Companion.getLOGGER().info("Response from manifest query: " + jsonRes, true);
                    JsonObject jsonObject = jsonRes;
                    Intrinsics.checkExpressionValueIsNotNull(jsonObject, "jsonRes");
                    JsonPrimitive jsonPrimitive = jsonObject.getAsJsonObject().getAsJsonPrimitive("DownloadURL");
                    Intrinsics.checkExpressionValueIsNotNull(jsonPrimitive, "jsonRes\n                \u2026nPrimitive(\"DownloadURL\")");
                    this.$urls.add(jsonPrimitive.getAsString());
                }
                catch (IOException e) {
                    ServerStarter.Companion.getLOGGER().error("Error while trying to get URL from cursemeta for mod " + mod, e);
                }
            }
            {
                this.this$0 = cursePackType;
                this.$ignoreSet = hashSet;
                this.$urls = concurrentLinkedQueue;
            }
        });
        ServerStarter.Companion.getLOGGER().info("Mods to download: " + urls, true);
        this.processMods(urls);
    }

    private final void processMods(Collection<String> mods) {
        ArrayList<Pattern> ignorePatterns = new ArrayList<Pattern>();
        for (String ignoreFile : this.configFile.getInstall().getIgnoreFiles()) {
            String string;
            if (!StringsKt.startsWith$default(ignoreFile, "mods/", false, 2, null)) continue;
            String string2 = ignoreFile;
            int n = StringsKt.lastIndexOf$default((CharSequence)ignoreFile, '/', 0, false, 6, null);
            ArrayList<Pattern> arrayList = ignorePatterns;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull(string3.substring(n), "(this as java.lang.String).substring(startIndex)");
            arrayList.add(Pattern.compile(string));
        }
        AtomicInteger count = new AtomicInteger(0);
        int totalCount = mods.size();
        ArrayList fallbackList = new ArrayList();
        ((Stream)mods.stream().parallel()).forEach((Consumer)new Consumer<String>(this, count, totalCount, fallbackList, ignorePatterns){
            final /* synthetic */ CursePackType this$0;
            final /* synthetic */ AtomicInteger $count;
            final /* synthetic */ int $totalCount;
            final /* synthetic */ ArrayList $fallbackList;
            final /* synthetic */ ArrayList $ignorePatterns;

            public final void accept(String s) {
                String string = s;
                Intrinsics.checkExpressionValueIsNotNull(string, "s");
                CursePackType.access$processSingleMod(this.this$0, string, this.$count, this.$totalCount, this.$fallbackList, this.$ignorePatterns);
            }
            {
                this.this$0 = cursePackType;
                this.$count = atomicInteger;
                this.$totalCount = n;
                this.$fallbackList = arrayList;
                this.$ignorePatterns = arrayList2;
            }
        });
        ArrayList secondFail = new ArrayList();
        Iterable $receiver$iv = fallbackList;
        for (Object element$iv : $receiver$iv) {
            String s = (String)element$iv;
            this.processSingleMod(s, count, totalCount, secondFail, (List<Pattern>)ignorePatterns);
        }
        if (!secondFail.isEmpty()) {
            ServerStarter.Companion.getLOGGER().warn("Failed to download (a) mod(s):");
            for (String s : secondFail) {
                ServerStarter.Companion.getLOGGER().warn("\t" + s);
            }
        }
    }

    private final void processSingleMod(String mod, AtomicInteger counter, int totalCount, List<String> fallbackList, List<Pattern> ignorePatterns) {
        try {
            String modName = FilenameUtils.getName(mod);
            for (Pattern ignorePattern : ignorePatterns) {
                if (!ignorePattern.matcher(modName).matches()) continue;
                PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "[" + counter.incrementAndGet() + "/" + totalCount + "] Skipped ignored mod: " + modName, false, 2, null);
            }
            InternetManager.INSTANCE.downloadToFile(mod, new File(this.getBasePath() + "mods/" + modName));
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "% 3d";
            Object[] objectArray = new Object[]{counter.incrementAndGet()};
            StringBuilder stringBuilder = new StringBuilder().append("[");
            PrimitiveLogger primitiveLogger = ServerStarter.Companion.getLOGGER();
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
            String string3 = string2;
            PrimitiveLogger.info$default(primitiveLogger, stringBuilder.append(string3).append("/").append(totalCount).append("] Downloaded mod: ").append(modName).toString(), false, 2, null);
        }
        catch (IOException e) {
            ServerStarter.Companion.getLOGGER().error("Failed to download mod", e);
            fallbackList.add(mod);
        }
        catch (URISyntaxException e) {
            ServerStarter.Companion.getLOGGER().error("Invalid url for " + mod, e);
        }
    }

    public CursePackType(@NotNull ConfigFile configFile) {
        Intrinsics.checkParameterIsNotNull(configFile, "configFile");
        super(configFile);
        this.configFile = configFile;
        this.forgeVersion = this.configFile.getInstall().getForgeVersion();
        this.mcVersion = this.configFile.getInstall().getMcVersion();
        this.oldFiles = new File(this.getBasePath() + "OLD_TO_DELETE/");
    }

    @NotNull
    public static final /* synthetic */ ConfigFile access$getConfigFile$p(CursePackType $this) {
        return $this.configFile;
    }

    public static final /* synthetic */ void access$processSingleMod(CursePackType $this, @NotNull String mod, @NotNull AtomicInteger counter, int totalCount, @NotNull List fallbackList, @NotNull List ignorePatterns) {
        $this.processSingleMod(mod, counter, totalCount, fallbackList, ignorePatterns);
    }
}

