/*
 * Decompiled with CFR 0.152.
 */
package atm.bloodworkxgaming.serverstarter.logger;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okio.BufferedSink;
import okio.Okio;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001c\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Latm/bloodworkxgaming/serverstarter/logger/PrimitiveLogger;", "", "outputFile", "Ljava/io/File;", "(Ljava/io/File;)V", "bufferedSink", "Lokio/BufferedSink;", "kotlin.jvm.PlatformType", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "pattern", "Lkotlin/text/Regex;", "currentTimeAnsi", "Lorg/fusesource/jansi/Ansi;", "error", "", "message", "", "throwable", "", "info", "logOnly", "", "stripColors", "warn", "serverstarter"})
public final class PrimitiveLogger {
    private final Regex pattern;
    private final DateTimeFormatter dateTimeFormatter;
    private final BufferedSink bufferedSink;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void info(@Nullable Object message, boolean logOnly) {
        String m = this.currentTimeAnsi().fgYellow().a("[INFO] ").fgDefault().a(message).reset().newline().toString();
        PrimitiveLogger primitiveLogger = this;
        synchronized (primitiveLogger) {
            try {
                String string = m;
                Intrinsics.checkExpressionValueIsNotNull(string, "m");
                this.bufferedSink.writeUtf8(this.stripColors(string));
            }
            catch (IOException e) {
                this.error("Error while logging!", e);
            }
            if (!logOnly) {
                String string = m;
                System.out.print((Object)string);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void info$default(PrimitiveLogger primitiveLogger, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        primitiveLogger.info(object, bl);
    }

    @JvmOverloads
    public final void info(@Nullable Object message) {
        PrimitiveLogger.info$default(this, message, false, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void warn(@Nullable Object message) {
        String m = this.currentTimeAnsi().fgMagenta().a("[WARNING] ").bgDefault().a(message).reset().newline().toString();
        PrimitiveLogger primitiveLogger = this;
        synchronized (primitiveLogger) {
            try {
                String string = m;
                Intrinsics.checkExpressionValueIsNotNull(string, "m");
                this.bufferedSink.writeUtf8(this.stripColors(string));
            }
            catch (IOException e) {
                this.error("Error while logging!", e);
            }
            String string = m;
            System.out.print((Object)string);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void error(@Nullable String message, @Nullable Throwable throwable) {
        String m = this.currentTimeAnsi().fgRed().a("[ERROR] ").bgDefault().a(message).reset().newline().toString();
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            m = m + "\n" + sw.toString();
        }
        PrimitiveLogger primitiveLogger = this;
        synchronized (primitiveLogger) {
            try {
                String string = m;
                Intrinsics.checkExpressionValueIsNotNull(string, "m");
                this.bufferedSink.writeUtf8(this.stripColors(string));
            }
            catch (IOException e) {
                System.err.println("Error while logging!");
                e.printStackTrace();
            }
            String string = m;
            System.out.print((Object)string);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* bridge */ /* synthetic */ void error$default(PrimitiveLogger primitiveLogger, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        primitiveLogger.error(string, throwable);
    }

    private final String stripColors(String message) {
        return this.pattern.replace((CharSequence)message, "");
    }

    private final Ansi currentTimeAnsi() {
        Ansi ansi = Ansi.ansi().fgBrightBlack().a("[" + LocalTime.now().format(this.dateTimeFormatter) + "] ").fgDefault();
        Intrinsics.checkExpressionValueIsNotNull(ansi, "Ansi.ansi().fgBrightBlac\u2026tter) + \"] \").fgDefault()");
        return ansi;
    }

    public PrimitiveLogger(@NotNull File outputFile) {
        Regex regex;
        Intrinsics.checkParameterIsNotNull(outputFile, "outputFile");
        String string = "\\x1b\\[[0-9;]*m";
        PrimitiveLogger primitiveLogger = this;
        primitiveLogger.pattern = regex = new Regex(string);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        this.bufferedSink = Okio.buffer(Okio.sink(outputFile));
        if (outputFile.exists()) {
            outputFile.delete();
        }
    }
}

