/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.localization.LocalizerDefault;

public class LocalizationHandler {
    private static final TreeMap<String, ILocalizer> LOCALIZERS = new TreeMap();

    public static void registerLocalizer(ILocalizer localizer, String ... languages) {
        Objects.requireNonNull(localizer);
        for (String language : Objects.requireNonNull(languages)) {
            LOCALIZERS.put(language, localizer);
        }
    }

    public static ILocalizer getCurrentLocalizer() {
        String language = "en_us";
        language = (String)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc != null) {
                return mc.func_135016_M().func_135041_c().getCode();
            }
            return "en_us";
        });
        return LOCALIZERS.computeIfAbsent(language, key -> LocalizerDefault.INSTANCE);
    }
}

