/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleRBTreeMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.materials.Material;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.CustomModule;
import thelm.jaopca.utils.JsonHelper;

public class MaterialDoubleFunctionDeserializer
implements JsonDeserializer<ToDoubleFunction<IMaterial>> {
    public static final MaterialDoubleFunctionDeserializer INSTANCE = new MaterialDoubleFunctionDeserializer();

    private MaterialDoubleFunctionDeserializer() {
    }

    public ToDoubleFunction<IMaterial> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "object");
        double defaultValue = helper.getDouble(json, "default");
        Object2DoubleRBTreeMap map = new Object2DoubleRBTreeMap();
        map.defaultReturnValue(defaultValue);
        if (json.has("materialTypes")) {
            JsonObject materialTypesJson = helper.getJsonObject(json, "materialTypes");
            for (Map.Entry entry : materialTypesJson.entrySet()) {
                double materialTypeValue = helper.getDouble((JsonElement)entry.getValue(), "element");
                switch ((String)entry.getKey()) {
                    case "ingot": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialDoubleFunctionDeserializer.lambda$deserialize$1((Object2DoubleMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "gem": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.GEMS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialDoubleFunctionDeserializer.lambda$deserialize$3((Object2DoubleMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "crystal": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.CRYSTALS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialDoubleFunctionDeserializer.lambda$deserialize$5((Object2DoubleMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "dust": {
                        MaterialHandler.getMaterials().stream().filter(m -> ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)m.getType()))).forEach(arg_0 -> MaterialDoubleFunctionDeserializer.lambda$deserialize$7((Object2DoubleMap)map, materialTypeValue, arg_0));
                    }
                }
            }
        }
        if (json.has("materials")) {
            JsonObject materialsJson = helper.getJsonObject(json, "materials");
            for (Map.Entry entry : materialsJson.entrySet()) {
                if (!MaterialHandler.containsMaterial((String)entry.getKey())) continue;
                map.put((Object)MaterialHandler.getMaterial((String)entry.getKey()), helper.getDouble((JsonElement)entry.getValue(), "element"));
            }
        }
        if (json.has("config") && helper.getBoolean(json, "config")) {
            String path = helper.getString(json, "path");
            String comment = json.has("comment") ? helper.getString(json, "comment") : "";
            CustomModule.instance.addCustomConfigDefiner((arg_0, arg_1) -> MaterialDoubleFunctionDeserializer.lambda$deserialize$8((Object2DoubleMap)map, path, comment, arg_0, arg_1));
        }
        return map;
    }

    private static /* synthetic */ void lambda$deserialize$8(Object2DoubleMap map, String path, String comment, IMaterial material, IDynamicSpecConfig config) {
        map.put((Object)material, config.getDefinedDouble(path, map.getDouble((Object)material), comment));
    }

    private static /* synthetic */ void lambda$deserialize$7(Object2DoubleMap map, double materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$5(Object2DoubleMap map, double materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$3(Object2DoubleMap map, double materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$1(Object2DoubleMap map, double materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }
}

