/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.item.Rarity;
import net.minecraft.util.BlockRenderLayer;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.utils.JsonHelper;

public class FluidFormSettingsDeserializer
implements JsonDeserializer<IFluidFormSettings> {
    public static final FluidFormSettingsDeserializer INSTANCE = new FluidFormSettingsDeserializer();

    private FluidFormSettingsDeserializer() {
    }

    public IFluidFormSettings deserialize(JsonElement jsonElement, JsonDeserializationContext context) {
        return this.deserialize(jsonElement, (Type)((Object)IFluidFormSettings.class), context);
    }

    public IFluidFormSettings deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject functionJson;
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "settings");
        IFluidFormSettings settings = FluidFormType.INSTANCE.getNewSettings();
        if (json.has("maxLevel")) {
            functionJson = helper.getJsonObject(json, "maxLevel");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)8);
            }
            settings.setMaxLevelFunction((ToIntFunction)helper.deserializeType(json, "maxLevel", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("renderLayer")) {
            settings.setRenderLayer((BlockRenderLayer)helper.deserializeType(json, "renderLayer", context, (Type)((Object)BlockRenderLayer.class)));
        }
        if (json.has("tickRate")) {
            functionJson = helper.getJsonObject(json, "tickRate");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)5);
            }
            settings.setTickRateFunction((ToIntFunction)helper.deserializeType(json, "tickRate", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("explosionResistance")) {
            functionJson = helper.getJsonObject(json, "explosionResistance");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)100);
            }
            settings.setExplosionResistanceFunction((ToDoubleFunction)helper.deserializeType(json, "explosionResistance", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("canSourcesMultiply")) {
            functionJson = helper.getJsonObject(json, "canSourcesMultiply");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setCanSourcesMultiplyFunction((Predicate)helper.deserializeType(json, "canSourcesMultiply", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("blockMaterial")) {
            functionJson = helper.getJsonObject(json, "blockMaterial");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", "iron");
            }
            settings.setMaterialFunction((Function)helper.deserializeType(json, "blockMaterial", context, BlockFormType.MATERIAL_FUNCTION_TYPE));
        }
        if (json.has("fillSound")) {
            settings.setFillSoundSupplier((Supplier)helper.deserializeType(json, "fillSound", context, FluidFormType.SOUND_EVENT_SUPPLIER_TYPE));
        }
        if (json.has("emptySound")) {
            settings.setFillSoundSupplier((Supplier)helper.deserializeType(json, "emptySound", context, FluidFormType.SOUND_EVENT_SUPPLIER_TYPE));
        }
        if (json.has("density")) {
            functionJson = helper.getJsonObject(json, "density");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1000);
            }
            settings.setDensityFunction((ToIntFunction)helper.deserializeType(json, "density", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("viscosity")) {
            functionJson = helper.getJsonObject(json, "viscosity");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1000);
            }
            settings.setViscosityFunction((ToIntFunction)helper.deserializeType(json, "viscosity", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("temperature")) {
            functionJson = helper.getJsonObject(json, "temperature");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)300);
            }
            settings.setTemperatureFunction((ToIntFunction)helper.deserializeType(json, "temperature", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("rarity")) {
            Rarity rarity = (Rarity)helper.deserializeType(json, "rarity", context, (Type)((Object)Rarity.class));
            settings.setDisplayRarityFunction(m -> rarity);
        }
        if (json.has("levelDecreasePerBlock")) {
            functionJson = helper.getJsonObject(json, "levelDecreasePerBlock");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1);
            }
            settings.setLevelDecreasePerBlockFunction((ToIntFunction)helper.deserializeType(json, "levelDecreasePerBlock", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("blockMaterial")) {
            functionJson = helper.getJsonObject(json, "blockMaterial");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", "water");
            }
            settings.setMaterialFunction((Function)helper.deserializeType(json, "blockMaterial", context, BlockFormType.MATERIAL_FUNCTION_TYPE));
        }
        if (json.has("lightValue")) {
            functionJson = helper.getJsonObject(json, "lightValue");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setLightValueFunction((ToIntFunction)helper.deserializeType(json, "lightValue", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("blockHardness")) {
            functionJson = helper.getJsonObject(json, "blockHardness");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)5);
            }
            settings.setBlockHardnessFunction((ToDoubleFunction)helper.deserializeType(json, "blockHardness", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("flammability")) {
            functionJson = helper.getJsonObject(json, "flammability");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setFlammabilityFunction((ToIntFunction)helper.deserializeType(json, "flammability", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("fireSpreadSpeed")) {
            functionJson = helper.getJsonObject(json, "fireSpreadSpeed");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setFireSpreadSpeedFunction((ToIntFunction)helper.deserializeType(json, "fireSpreadSpeed", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("isFireSource")) {
            functionJson = helper.getJsonObject(json, "isFireSource");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setIsFireSourceFunction((Predicate)helper.deserializeType(json, "isFireSource", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("itemStackLimit")) {
            functionJson = helper.getJsonObject(json, "itemStackLimit");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)64);
            }
            settings.setItemStackLimitFunction((ToIntFunction)helper.deserializeType(json, "itemStackLimit", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("isBeaconPayment")) {
            functionJson = helper.getJsonObject(json, "itemStackLimit");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setIsBeaconPaymentFunction((Predicate)helper.deserializeType(json, "isBeaconPayment", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("hasEffect")) {
            boolean hasEffect = helper.getBoolean(json, "hasEffect");
            settings.setHasEffectFunction(m -> m.hasEffect() || hasEffect);
        }
        if (json.has("burnTime")) {
            JsonObject functionJson2 = helper.getJsonObject(json, "burnTime");
            if (!functionJson2.has("default")) {
                functionJson2.addProperty("default", (Number)-1);
            }
            settings.setBurnTimeFunction((ToIntFunction)helper.deserializeType(json, "burnTime", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        return settings;
    }
}

