/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api;

import com.google.gson.JsonDeserializer;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.jaopca.api.blocks.IBlockFormType;
import thelm.jaopca.api.entities.IEntityTypeFormType;
import thelm.jaopca.api.fluids.IFluidFormType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.helpers.IJsonHelper;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.items.IItemFormType;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;

public abstract class JAOPCAApi {
    private static JAOPCAApi instance;

    protected static void setInstance(JAOPCAApi api) {
        if (instance == null) {
            instance = api;
        }
    }

    public static boolean initialized() {
        return instance != null;
    }

    public static JAOPCAApi instance() {
        if (instance == null) {
            throw new IllegalStateException("Got API instance before it is set");
        }
        return instance;
    }

    public abstract IBlockFormType blockFormType();

    public abstract IItemFormType itemFormType();

    public abstract IFluidFormType fluidFormType();

    public abstract IEntityTypeFormType entityTypeFormType();

    public abstract IFormType getFormType(String var1);

    public abstract IForm newForm(IModule var1, String var2, IFormType var3);

    public abstract IFormRequest newFormRequest(IModule var1, IForm ... var2);

    public abstract IMiscHelper miscHelper();

    public abstract IJsonHelper jsonHelper();

    public abstract JsonDeserializer<Enum<?>> enumDeserializer();

    public abstract JsonDeserializer<Function<IMaterial, Enum<?>>> materialEnumFunctionDeserializer();

    public abstract <T> JsonDeserializer<Function<IMaterial, T>> materialMappedFunctionDeserializer(Function<String, T> var1, Function<T, String> var2);

    public abstract JsonDeserializer<Function<IMaterial, ?>> materialFunctionDeserializer();

    public abstract JsonDeserializer<Supplier<IForgeRegistryEntry<?>>> forgeRegistryEntrySupplierDeserializer();

    public abstract IForm getForm(String var1);

    public abstract IMaterial getMaterial(String var1);

    public abstract ItemGroup itemGroup();

    public abstract Set<ResourceLocation> getBlockTags();

    public abstract Set<ResourceLocation> getItemTags();

    public abstract Set<ResourceLocation> getFluidTags();

    public abstract Set<ResourceLocation> getEntityTypeTags();

    public abstract Set<ResourceLocation> getRecipes();

    public abstract Set<ResourceLocation> getLootTables();

    public abstract Set<ResourceLocation> getAdvancements();

    public abstract ILocalizer currentLocalizer();

    public abstract boolean registerFormType(IFormType var1);

    public abstract boolean registerDefinedBlockTag(ResourceLocation var1);

    public abstract boolean registerDefinedItemTag(ResourceLocation var1);

    public abstract boolean registerDefinedFluidTag(ResourceLocation var1);

    public abstract boolean registerDefinedEntityTypeTag(ResourceLocation var1);

    public abstract boolean registerBlockTag(ResourceLocation var1, Supplier<? extends Block> var2);

    public abstract boolean registerBlockTag(ResourceLocation var1, Block var2);

    public abstract boolean registerBlockTag(ResourceLocation var1, ResourceLocation var2);

    public abstract boolean registerItemTag(ResourceLocation var1, Supplier<? extends Item> var2);

    public abstract boolean registerItemTag(ResourceLocation var1, Item var2);

    public abstract boolean registerItemTag(ResourceLocation var1, ResourceLocation var2);

    public abstract boolean registerFluidTag(ResourceLocation var1, Supplier<? extends Fluid> var2);

    public abstract boolean registerFluidTag(ResourceLocation var1, Fluid var2);

    public abstract boolean registerFluidTag(ResourceLocation var1, ResourceLocation var2);

    public abstract boolean registerEntityTypeTag(ResourceLocation var1, Supplier<? extends EntityType<?>> var2);

    public abstract boolean registerEntityTypeTag(ResourceLocation var1, EntityType<?> var2);

    public abstract boolean registerEntityTypeTag(ResourceLocation var1, ResourceLocation var2);

    public abstract boolean registerRecipe(ResourceLocation var1, Supplier<? extends IRecipe<?>> var2);

    public abstract boolean registerRecipe(ResourceLocation var1, IRecipe<?> var2);

    public abstract boolean registerShapedRecipe(ResourceLocation var1, String var2, Object var3, int var4, Object ... var5);

    public abstract boolean registerShapedRecipe(ResourceLocation var1, Object var2, int var3, Object ... var4);

    public abstract boolean registerShapelessRecipe(ResourceLocation var1, String var2, Object var3, int var4, Object ... var5);

    public abstract boolean registerShapelessRecipe(ResourceLocation var1, Object var2, int var3, Object ... var4);

    public abstract boolean registerFurnaceRecipe(ResourceLocation var1, String var2, Object var3, Object var4, int var5, float var6, int var7);

    public abstract boolean registerFurnaceRecipe(ResourceLocation var1, Object var2, Object var3, int var4, float var5, int var6);

    public abstract boolean registerBlastingRecipe(ResourceLocation var1, String var2, Object var3, Object var4, int var5, float var6, int var7);

    public abstract boolean registerBlastingRecipe(ResourceLocation var1, Object var2, Object var3, int var4, float var5, int var6);

    public abstract boolean registerSmokingRecipe(ResourceLocation var1, String var2, Object var3, Object var4, int var5, float var6, int var7);

    public abstract boolean registerSmokingRecipe(ResourceLocation var1, Object var2, Object var3, int var4, float var5, int var6);

    public abstract boolean registerCampfireCookingRecipe(ResourceLocation var1, String var2, Object var3, Object var4, int var5, int var6);

    public abstract boolean registerCampfireCookingRecipe(ResourceLocation var1, Object var2, Object var3, int var4, int var5);

    public abstract boolean registerStonecuttingRecipe(ResourceLocation var1, String var2, Object var3, Object var4, int var5);

    public abstract boolean registerStonecuttingRecipe(ResourceLocation var1, Object var2, Object var3, int var4);

    public abstract boolean registerLootTable(ResourceLocation var1, Supplier<LootTable> var2);

    public abstract boolean registerLootTable(ResourceLocation var1, LootTable var2);

    public abstract boolean registerAdvancement(ResourceLocation var1, Supplier<Advancement.Builder> var2);

    public abstract boolean registerAdvancement(ResourceLocation var1, Advancement.Builder var2);

    public abstract void registerLocalizer(ILocalizer var1, String ... var2);
}

