/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.worldgen;

import java.util.function.Predicate;
import mcjty.rftoolsbase.blocks.ModBlocks;
import mcjty.rftoolsbase.config.Config;
import mcjty.rftoolsbase.worldgen.DimensionCompositeFeature;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class OreGenerator {
    private static final Predicate<BlockState> IS_NETHERACK = state -> state.func_177230_c() == Blocks.field_150424_aL;
    private static final Predicate<BlockState> IS_ENDSTONE = state -> state.func_177230_c() == Blocks.field_150377_bs;

    public static void init() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            int netherChances;
            int overworldChances = (Integer)Config.OVERWORLD_ORE_CHANCES.get();
            if (overworldChances > 0) {
                ConfiguredFeature featureOverworld = Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ModBlocks.DIMENSIONAL_SHARD_OVERWORLD.func_176223_P(), ((Integer)Config.OVERWORLD_ORE_VEINSIZE.get()).intValue()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(overworldChances, ((Integer)Config.OVERWORLD_ORE_MINY.get()).intValue(), 0, (Integer)Config.OVERWORLD_ORE_MAXY.get() - (Integer)Config.OVERWORLD_ORE_MINY.get()));
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, new DimensionCompositeFeature(featureOverworld, DimensionType.field_223227_a_));
            }
            if ((netherChances = ((Integer)Config.NETHER_ORE_CHANCES.get()).intValue()) <= 0) continue;
            ConfiguredFeature featureNether = Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.DIMENSIONAL_SHARD_NETHER.func_176223_P(), ((Integer)Config.NETHER_ORE_VEINSIZE.get()).intValue()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(netherChances, ((Integer)Config.NETHER_ORE_MINY.get()).intValue(), 0, (Integer)Config.NETHER_ORE_MAXY.get() - (Integer)Config.NETHER_ORE_MINY.get()));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, new DimensionCompositeFeature(featureNether, DimensionType.field_223228_b_));
        }
    }
}

