/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.items;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.api.smartwrench.ISmartWrenchSelector;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class SmartWrenchItem
extends Item
implements SmartWrench {
    private final SmartWrenchMode mode;

    public SmartWrenchItem(SmartWrenchMode mode) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(RFToolsBase.setup.getTab()));
        this.mode = mode;
        this.setRegistryName(mode == SmartWrenchMode.MODE_WRENCH ? "smartwrench" : "smartwrench_select");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            ItemStack newStack;
            SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
            CompoundNBT tag = stack.func_77978_p();
            if (mode == SmartWrenchMode.MODE_WRENCH) {
                mode = SmartWrenchMode.MODE_SELECT;
                newStack = new ItemStack((IItemProvider)ModItems.SMARTWRENCH_SELECT);
            } else {
                mode = SmartWrenchMode.MODE_WRENCH;
                newStack = new ItemStack((IItemProvider)ModItems.SMARTWRENCH);
            }
            newStack.func_77982_d(tag);
            player.func_184611_a(hand, newStack);
            Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Smart wrench is now in " + mode.getName() + " mode."));
        }
        return super.func_77659_a(world, player, hand);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            GlobalCoordinate b;
            BlockState state;
            Block block;
            PlayerEntity player = context.func_195999_j();
            Hand hand = context.func_221531_n();
            ItemStack stack = context.func_195996_i();
            BlockPos pos = context.func_195995_a();
            if (player != null && player.func_70093_af() && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof BaseBlock && state.func_215687_a(world, player, hand, new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), pos, context.func_221533_k()))) {
                return ActionResultType.SUCCESS;
            }
            SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
            if (mode == SmartWrenchMode.MODE_SELECT && (b = SmartWrenchItem.getCurrentBlock(stack)) != null) {
                if (!b.getDimension().equals(world.func_201675_m().func_186058_p())) {
                    if (player != null) {
                        Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "The selected block is in another dimension!"));
                    }
                    return ActionResultType.FAIL;
                }
                TileEntity te = world.func_175625_s(b.getCoordinate());
                if (te instanceof ISmartWrenchSelector) {
                    ISmartWrenchSelector smartWrenchSelector = (ISmartWrenchSelector)te;
                    smartWrenchSelector.selectBlock(player, pos);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        super.func_77624_a(itemStack, world, list, flags);
        GlobalCoordinate b = SmartWrenchItem.getCurrentBlock(itemStack);
        if (b != null) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Block: " + BlockPosTools.toString((BlockPos)b.getCoordinate()) + " at dimension " + b.getDimension()));
        }
        SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(itemStack);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Right-click on air to change mode."));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Mode: " + mode.getName()));
        if (mode == SmartWrenchMode.MODE_WRENCH) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Use as a normal wrench:"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "    Sneak-right-click to pick up machines."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "    Right-click to rotate machines."));
        } else if (mode == SmartWrenchMode.MODE_SELECT) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Use as a block selector:"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "    Sneak-right-click select master block."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "    Right-click to associate blocks with master."));
        }
    }

    public SmartWrenchMode getMode() {
        return this.mode;
    }

    public SmartWrenchMode getMode(ItemStack itemStack) {
        return SmartWrenchItem.getCurrentMode(itemStack);
    }

    public static SmartWrenchMode getCurrentMode(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof SmartWrenchItem) {
            return ((SmartWrenchItem)itemStack.func_77973_b()).getMode();
        }
        return SmartWrenchMode.MODE_WRENCH;
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalCoordinate c) {
        CompoundNBT tagCompound = itemStack.func_196082_o();
        if (c == null) {
            tagCompound.func_82580_o("selectedX");
            tagCompound.func_82580_o("selectedY");
            tagCompound.func_82580_o("selectedZ");
            tagCompound.func_82580_o("selectedDim");
        } else {
            tagCompound.func_74768_a("selectedX", c.getCoordinate().func_177958_n());
            tagCompound.func_74768_a("selectedY", c.getCoordinate().func_177956_o());
            tagCompound.func_74768_a("selectedZ", c.getCoordinate().func_177952_p());
            tagCompound.func_74778_a("selectedDim", c.getDimension().getRegistryName().toString());
        }
    }

    public static GlobalCoordinate getCurrentBlock(ItemStack itemStack) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("selectedX")) {
            int x = tagCompound.func_74762_e("selectedX");
            int y = tagCompound.func_74762_e("selectedY");
            int z = tagCompound.func_74762_e("selectedZ");
            String dim = tagCompound.func_74779_i("selectedDim");
            return new GlobalCoordinate(new BlockPos(x, y, z), DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(dim)));
        }
        return null;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }
}

