/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class TextureTracker {
    private static final SetMultimap<String, ResourceLocation> missingTextures = HashMultimap.create();
    private static final Set<String> badTextureDomains = Sets.newHashSet();
    private static final Table<String, String, Set<ResourceLocation>> brokenTextures = HashBasedTable.create();

    public static void trackMissingTexture(ResourceLocation resourceLocation) {
        badTextureDomains.add(resourceLocation.func_110624_b());
        missingTextures.put((Object)resourceLocation.func_110624_b(), (Object)resourceLocation);
    }

    public static void trackBrokenTexture(ResourceLocation resourceLocation, String error) {
        badTextureDomains.add(resourceLocation.func_110624_b());
        Set badType = (Set)brokenTextures.get((Object)resourceLocation.func_110624_b(), (Object)error);
        if (badType == null) {
            badType = Sets.newHashSet();
            brokenTextures.put((Object)resourceLocation.func_110624_b(), MoreObjects.firstNonNull((Object)error, (Object)"Unknown error"), (Object)badType);
        }
        badType.add(resourceLocation);
    }
}

