/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModelDynBucket
implements IUnbakedModel {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("forge", "dynbucket"), "inventory");
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IUnbakedModel MODEL = new ModelDynBucket();
    @Nullable
    private final ResourceLocation baseLocation;
    @Nullable
    private final ResourceLocation liquidLocation;
    @Nullable
    private final ResourceLocation coverLocation;
    @Nullable
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean tint;

    public ModelDynBucket() {
        this(null, null, null, null, false, true);
    }

    public ModelDynBucket(@Nullable ResourceLocation baseLocation, @Nullable ResourceLocation liquidLocation, @Nullable ResourceLocation coverLocation, @Nullable Fluid fluid, boolean flipGas, boolean tint) {
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.tint = tint;
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        if (this.fluid != null) {
            builder.add((Object)this.fluid.getAttributes().getStillTexture());
        }
        return builder.build();
    }

    public Collection<ResourceLocation> func_187965_e() {
        return Collections.emptyList();
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        IModelState state = sprite.getState();
        ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap = PerspectiveMapWrapper.getTransforms(state);
        if (this.flipGas && this.fluid != null && this.fluid.getAttributes().isLighterThanAir()) {
            sprite = new ModelStateComposition(state, TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
            state = sprite.getState();
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite fluidSprite = null;
        TextureAtlasSprite particleSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = spriteGetter.apply(this.fluid.getAttributes().getStillTexture());
        }
        Random random = new Random();
        if (this.baseLocation != null) {
            IBakedModel model = new ItemLayerModel((ImmutableList<ResourceLocation>)ImmutableList.of((Object)this.baseLocation)).bake(bakery, spriteGetter, sprite, format);
            random.setSeed(42L);
            builder.addAll((Iterable)model.func_200117_a(null, null, random));
            particleSprite = model.func_177554_e();
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            TextureAtlasSprite liquid = spriteGetter.apply(this.liquidLocation);
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.468625f, Direction.NORTH, this.tint ? this.fluid.getAttributes().getColor() : -1, 1));
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.531375f, Direction.SOUTH, this.tint ? this.fluid.getAttributes().getColor() : -1, 1));
            particleSprite = fluidSprite;
        }
        if (this.coverLocation != null) {
            TextureAtlasSprite cover = spriteGetter.apply(this.coverLocation);
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, cover, Direction.NORTH, -1, 2));
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, cover, Direction.SOUTH, -1, 2));
            if (particleSprite == null) {
                particleSprite = cover;
            }
        }
        return new BakedDynBucket(bakery, this, (ImmutableList<BakedQuad>)builder.build(), particleSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap(transformMap), Maps.newHashMap(), transform.isIdentity());
    }

    public ModelDynBucket process(ImmutableMap<String, String> customData) {
        ResourceLocation fluidName = new ResourceLocation((String)customData.get((Object)"fluid"));
        Fluid fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        boolean tint = this.tint;
        if (customData.containsKey((Object)"applyTint")) {
            String string;
            switch (string = (String)customData.get((Object)"applyTint")) {
                case "true": {
                    tint = true;
                    break;
                }
                case "false": {
                    tint = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("DynBucket custom data \"applyTint\" must have value 'true' or 'false' (was '%s')", string));
                }
            }
        }
        return new ModelDynBucket(this.baseLocation, this.liquidLocation, this.coverLocation, fluid, flip, tint);
    }

    public ModelDynBucket retexture(ImmutableMap<String, String> textures) {
        ResourceLocation base = this.baseLocation;
        ResourceLocation liquid = this.liquidLocation;
        ResourceLocation cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new ResourceLocation((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new ResourceLocation((String)textures.get((Object)"cover"));
        }
        return new ModelDynBucket(base, liquid, cover, this.fluid, this.flipGas, this.tint);
    }

    @Nullable
    protected static IResource getResource(ResourceLocation resourceLocation) {
        try {
            return Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Nullable
    protected static PngSizeInfo getSizeInfo(IResource resource) {
        try {
            return new PngSizeInfo(resource.toString(), resource.func_199027_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class BakedDynBucket
    extends BakedItemModel {
        private final ModelDynBucket parent;
        private final Map<String, IBakedModel> cache;
        private final VertexFormat format;

        BakedDynBucket(ModelBakery bakery, ModelDynBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache, boolean untransformed) {
            super(quads, particle, transforms, new BakedDynBucketOverrideHandler(bakery), untransformed);
            this.format = format;
            this.parent = parent;
            this.cache = cache;
        }
    }

    private static final class BakedDynBucketOverrideHandler
    extends ItemOverrideList {
        private final ModelBakery bakery;

        private BakedDynBucketOverrideHandler(ModelBakery bakery) {
            this.bakery = bakery;
        }

        public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            return FluidUtil.getFluidContained(stack).map(fluidStack -> {
                BakedDynBucket model = (BakedDynBucket)originalModel;
                Fluid fluid = fluidStack.getFluid();
                String name = fluid.getRegistryName().toString();
                if (!model.cache.containsKey(name)) {
                    ModelDynBucket parent = model.parent.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"fluid", (Object)name));
                    Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    IBakedModel bakedModel = parent.bake(this.bakery, textureGetter, new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)model.transforms), model.format);
                    model.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return (IBakedModel)model.cache.get(name);
            }).orElse(originalModel);
        }
    }

    private static final class BucketCoverSprite
    extends TextureAtlasSprite {
        private final ResourceLocation bucket = new ResourceLocation("item/bucket");
        private final ResourceLocation bucketCoverMask = new ResourceLocation("forge", "item/vanilla_bucket_cover_mask");
        private final ImmutableList<ResourceLocation> dependencies = ImmutableList.of((Object)this.bucket, (Object)this.bucketCoverMask);

        private BucketCoverSprite(ResourceLocation res) {
            super(res, ModelDynBucket.getSizeInfo(ModelDynBucket.getResource(new ResourceLocation("textures/item/bucket.png"))), (AnimationMetadataSection)ModelDynBucket.getResource(new ResourceLocation("textures/item/bucket.png")).func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a));
        }
    }

    private static final class BucketBaseSprite
    extends TextureAtlasSprite {
        private final ResourceLocation bucket = new ResourceLocation("item/bucket");
        private final ImmutableList<ResourceLocation> dependencies = ImmutableList.of((Object)this.bucket);

        private BucketBaseSprite(ResourceLocation res) {
            super(res, ModelDynBucket.getSizeInfo(ModelDynBucket.getResource(new ResourceLocation("textures/item/bucket.png"))), (AnimationMetadataSection)ModelDynBucket.getResource(new ResourceLocation("textures/item/bucket.png")).func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a));
        }
    }

    public static enum LoaderDynBucket implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("forge") && modelLocation.func_110623_a().contains("forgebucket");
        }

        @Override
        public IUnbakedModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void register(AtlasTexture map) {
            TextureAtlasSprite textureAtlasSprite;
            if (ModelDynBucket.getResource(new ResourceLocation("forge", "textures/items/bucket_cover.png")) == null) {
                ResourceLocation bucketCover = new ResourceLocation("forge", "items/bucket_cover");
                textureAtlasSprite = new BucketCoverSprite(bucketCover);
            }
            if (ModelDynBucket.getResource(new ResourceLocation("forge", "textures/items/bucket_base.png")) == null) {
                ResourceLocation bucketBase = new ResourceLocation("forge", "items/bucket_base");
                textureAtlasSprite = new BucketBaseSprite(bucketBase);
            }
        }
    }
}

