/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tehnut.harvest.HarvestConfig;
import tehnut.harvest.IReplantHandler;
import tehnut.harvest.ReplantHandlers;

@Mod(value="harvest")
public class Harvest {
    public static final String MODID = "harvest";
    public static final Logger LOGGER = LogManager.getLogger((String)"harvest");
    public static final Tag<Item> SEED_TAG = new ItemTags.Wrapper(new ResourceLocation("harvest", "seeds"));
    public static final Map<Block, IReplantHandler> CUSTOM_HANDLERS = Maps.newHashMap();
    public static HarvestConfig config;

    public Harvest() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, EventHandler::onInteract);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        File configFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "harvest.json");
        try (FileReader reader = new FileReader(configFile);){
            config = (HarvestConfig)new Gson().fromJson((Reader)reader, HarvestConfig.class);
            Harvest.debug("Successfully loaded config", new Object[0]);
            Harvest.debug("Currently enabled crops: {}", Joiner.on((String)" | ").join(config.getCrops()));
        }
        catch (IOException e) {
            config = new HarvestConfig();
            Harvest.debug("Config not found, generating a new one.", new Object[0]);
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)config));
            }
            catch (IOException e2) {
                Harvest.debug("Failed to generate new config", e2);
            }
        }
    }

    static void debug(String message, Object ... args) {
        if (config.additionalLogging()) {
            LOGGER.info("[DEBUG] " + message, args);
        }
    }

    public static class EventHandler {
        public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
            if (!(event.getWorld() instanceof ServerWorld)) {
                return;
            }
            if (event.getHand() != Hand.MAIN_HAND) {
                return;
            }
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            IReplantHandler handler = CUSTOM_HANDLERS.getOrDefault(state.func_177230_c(), ReplantHandlers.CONFIG);
            ActionResultType result = handler.handlePlant((ServerWorld)event.getWorld(), event.getPos(), state, event.getEntityPlayer(), event.getWorld().func_175625_s(event.getPos()));
            if (result == ActionResultType.SUCCESS) {
                event.getPlayer().func_184609_a(event.getHand());
                event.getPlayer().func_71020_j(config.getExhaustionPerHarvest());
            }
            Harvest.debug("Attempted crop harvest with result {} has completed", result);
            event.setUseItem(result == ActionResultType.SUCCESS ? Event.Result.DENY : event.getUseItem());
        }
    }
}

